###
###

.pkgname <- "BSgenome.Mmulatta.UCSC.rheMac8"

.seqnames <- NULL

.circ_seqs <- "chrM"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Macaca mulatta",
        common_name="Rhesus",
        provider="UCSC",
        provider_version="rheMac8",
        release_date="Nov. 2015",
        release_name="Baylor College of Medicine HGSC Mmul_8.0.1",
        source_url="http://hgdownload.soe.ucsc.edu/goldenPath/rheMac8/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Mmulatta"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

