###
###

.pkgname <- "BSgenome.Mmulatta.UCSC.rheMac10"

.seqnames <- NULL

.circ_seqs <- "chrM"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Macaca mulatta",
        common_name="Rhesus",
        provider="UCSC",
        provider_version="rheMac10",
        release_date="Feb. 2019",
        release_name="The Genome Institute at Washington University School of Medicine Mmul_10",
        source_url="http://hgdownload.soe.ucsc.edu/goldenPath/rheMac10/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Mmulatta"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

