###
###

.pkgname <- "BSgenome.Hsapiens.NCBI.GRCh38"

.seqnames <- c("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11",
"12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22",
"X", "Y",
"MT",
"HSCHR1_CTG1_UNLOCALIZED",
"HSCHR1_CTG2_UNLOCALIZED",
"HSCHR1_CTG3_UNLOCALIZED",
"HSCHR1_CTG4_UNLOCALIZED",
"HSCHR1_CTG5_UNLOCALIZED",
"HSCHR1_CTG6_UNLOCALIZED",
"HSCHR1_CTG7_UNLOCALIZED",
"HSCHR1_CTG8_UNLOCALIZED",
"HSCHR1_CTG9_UNLOCALIZED",
"HSCHR2_RANDOM_CTG1",
"HSCHR2_RANDOM_CTG2",
"HSCHR3UN_CTG2",
"HSCHR4_RANDOM_CTG4",
"HSCHR5_RANDOM_CTG1",
"HSCHR9_UNLOCALIZED_CTG1",
"HSCHR9_UNLOCALIZED_CTG2",
"HSCHR9_UNLOCALIZED_CTG3",
"HSCHR9_UNLOCALIZED_CTG4",
"HSCHR11_CTG1_UNLOCALIZED",
"HSCHR14_CTG1_UNLOCALIZED",
"HSCHR14_CTG2_UNLOCALIZED",
"HSCHR14_CTG3_UNLOCALIZED",
"HSCHR14_CTG4_UNLOCALIZED",
"HSCHR14_CTG5_UNLOCALIZED",
"HSCHR14_CTG6_UNLOCALIZED",
"HSCHR14_CTG7_UNLOCALIZED",
"HSCHR14_CTG8_UNLOCALIZED",
"HSCHR15_RANDOM_CTG1",
"HSCHR16_RANDOM_CTG1",
"HSCHR17_RANDOM_CTG3",
"HSCHR17_RANDOM_CTG4",
"HSCHR17_RANDOM_CTG5",
"HSCHR22_UNLOCALIZED_CTG1",
"HSCHR22_UNLOCALIZED_CTG2",
"HSCHR22_UNLOCALIZED_CTG3",
"HSCHR22_UNLOCALIZED_CTG4",
"HSCHR22_UNLOCALIZED_CTG5",
"HSCHR22_UNLOCALIZED_CTG6",
"HSCHR22_UNLOCALIZED_CTG7",
"HSCHR22_UNLOCALIZED_CTG8",
"HSCHR22_UNLOCALIZED_CTG9",
"HSCHRY_RANDOM_CTG1",
"HSCHRUN_RANDOM_100",
"HSCHRUN_RANDOM_101",
"HSCHRUN_RANDOM_102",
"HSCHRUN_RANDOM_103",
"HSCHRUN_RANDOM_104",
"HSCHRUN_RANDOM_105",
"HSCHRUN_RANDOM_106",
"HSCHRUN_RANDOM_107",
"HSCHRUN_RANDOM_108",
"HSCHRUN_RANDOM_109",
"HSCHRUN_RANDOM_110",
"HSCHRUN_RANDOM_111",
"HSCHRUN_RANDOM_112",
"HSCHRUN_RANDOM_113",
"HSCHRUN_RANDOM_114",
"HSCHRUN_RANDOM_115",
"HSCHRUN_RANDOM_116",
"HSCHRUN_RANDOM_117",
"HSCHRUN_RANDOM_118",
"HSCHRUN_RANDOM_119",
"HSCHRUN_RANDOM_120",
"HSCHRUN_RANDOM_121",
"HSCHRUN_RANDOM_122",
"HSCHRUN_RANDOM_123",
"HSCHRUN_RANDOM_124",
"HSCHRUN_RANDOM_125",
"HSCHRUN_RANDOM_126",
"HSCHRUN_RANDOM_127",
"HSCHRUN_RANDOM_128",
"HSCHRUN_RANDOM_129",
"HSCHRUN_RANDOM_130",
"HSCHRUN_RANDOM_131",
"HSCHRUN_RANDOM_132",
"HSCHRUN_RANDOM_133",
"HSCHRUN_RANDOM_134",
"HSCHRUN_RANDOM_135",
"HSCHRUN_RANDOM_136",
"HSCHRUN_RANDOM_137",
"HSCHRUN_RANDOM_138",
"HSCHRUN_RANDOM_139",
"HSCHRUN_RANDOM_140",
"HSCHRUN_RANDOM_141",
"HSCHRUN_RANDOM_142",
"HSCHRUN_RANDOM_143",
"HSCHRUN_RANDOM_144",
"HSCHRUN_RANDOM_145",
"HSCHRUN_RANDOM_146",
"HSCHRUN_RANDOM_147",
"HSCHRUN_RANDOM_148",
"HSCHRUN_RANDOM_149",
"HSCHRUN_RANDOM_154",
"HSCHRUN_RANDOM_155",
"HSCHRUN_RANDOM_156",
"HSCHRUN_RANDOM_157",
"HSCHRUN_RANDOM_158",
"HSCHRUN_RANDOM_159",
"HSCHRUN_RANDOM_160",
"HSCHRUN_RANDOM_161",
"HSCHRUN_RANDOM_162",
"HSCHRUN_RANDOM_163",
"HSCHRUN_RANDOM_164",
"HSCHRUN_RANDOM_165",
"HSCHRUN_RANDOM_166",
"HSCHRUN_RANDOM_167",
"HSCHRUN_RANDOM_168",
"HSCHRUN_RANDOM_169",
"HSCHRUN_RANDOM_170",
"HSCHRUN_RANDOM_171",
"HSCHRUN_RANDOM_172",
"HSCHRUN_RANDOM_173",
"HSCHRUN_RANDOM_174",
"HSCHRUN_RANDOM_175",
"HSCHRUN_RANDOM_176",
"HSCHRUN_RANDOM_177",
"HSCHRUN_RANDOM_178",
"HSCHRUN_RANDOM_179",
"HSCHRUN_RANDOM_180",
"HSCHRUN_RANDOM_181",
"HSCHRUN_RANDOM_182",
"HSCHRUN_RANDOM_183",
"HSCHRUN_RANDOM_184",
"HSCHRUN_RANDOM_185",
"HSCHRUN_RANDOM_186",
"HSCHRUN_RANDOM_187",
"HSCHRUN_RANDOM_188",
"HSCHRUN_RANDOM_189",
"HSCHRUN_RANDOM_190",
"HSCHRUN_RANDOM_191",
"HSCHRUN_RANDOM_192",
"HSCHRUN_RANDOM_193",
"HSCHRUN_RANDOM_194",
"HSCHRUN_RANDOM_195",
"HSCHRUN_RANDOM_196",
"HSCHRUN_RANDOM_197",
"HSCHRUN_RANDOM_198",
"HSCHRUN_RANDOM_199",
"HSCHRUN_RANDOM_200",
"HSCHRUN_RANDOM_201",
"HSCHRUN_RANDOM_202",
"HSCHRUN_RANDOM_203",
"HSCHRUN_RANDOM_204",
"HSCHRUN_RANDOM_CTG1",
"HSCHRUN_RANDOM_CTG10",
"HSCHRUN_RANDOM_CTG11",
"HSCHRUN_RANDOM_CTG16",
"HSCHRUN_RANDOM_CTG17",
"HSCHRUN_RANDOM_CTG19",
"HSCHRUN_RANDOM_CTG2",
"HSCHRUN_RANDOM_CTG20",
"HSCHRUN_RANDOM_CTG21",
"HSCHRUN_RANDOM_CTG22",
"HSCHRUN_RANDOM_CTG23",
"HSCHRUN_RANDOM_CTG24",
"HSCHRUN_RANDOM_CTG25",
"HSCHRUN_RANDOM_CTG26",
"HSCHRUN_RANDOM_CTG27",
"HSCHRUN_RANDOM_CTG28",
"HSCHRUN_RANDOM_CTG29",
"HSCHRUN_RANDOM_CTG30",
"HSCHRUN_RANDOM_CTG33",
"HSCHRUN_RANDOM_CTG34",
"HSCHRUN_RANDOM_CTG35",
"HSCHRUN_RANDOM_CTG36",
"HSCHRUN_RANDOM_CTG4",
"HSCHRUN_RANDOM_CTG42",
"HSCHRUN_RANDOM_CTG6",
"HSCHRUN_RANDOM_CTG9",
"HSCHR1_1_CTG3",
"HSCHR1_2_CTG3",
"HSCHR1_1_CTG11",
"HSCHR1_4_CTG31",
"HSCHR1_1_CTG31",
"HSCHR1_2_CTG31",
"HSCHR1_3_CTG31",
"HSCHR1_4_CTG32_1",
"HSCHR1_3_CTG32_1",
"HSCHR1_1_CTG32_1",
"HSCHR1_2_CTG32_1",
"HSCHR2_2_CTG1",
"HSCHR2_3_CTG1",
"HSCHR2_4_CTG1",
"HSCHR2_1_CTG1",
"HSCHR2_1_CTG5",
"HSCHR2_1_CTG7",
"HSCHR2_5_CTG7_2",
"HSCHR2_4_CTG7_2",
"HSCHR2_3_CTG7_2",
"HSCHR2_2_CTG7_2",
"HSCHR2_1_CTG7_2",
"HSCHR2_3_CTG15",
"HSCHR2_1_CTG15",
"HSCHR3_1_CTG1",
"HSCHR3_3_CTG1",
"HSCHR3_4_CTG2_1",
"HSCHR3_1_CTG2_1",
"HSCHR3_2_CTG2_1",
"HSCHR3_3_CTG2_1",
"HSCHR3_5_CTG2_1",
"HSCHR3_1_CTG3",
"HSCHR3_2_CTG3",
"HSCHR3_9_CTG3",
"HSCHR4_1_CTG4",
"HSCHR4_1_CTG6",
"HSCHR4_1_CTG8_1",
"HSCHR4_1_CTG9",
"HSCHR4_4_CTG12",
"HSCHR4_1_CTG12",
"HSCHR4_2_CTG12",
"HSCHR4_5_CTG12",
"HSCHR4_3_CTG12",
"HSCHR5_5_CTG1",
"HSCHR5_4_CTG1",
"HSCHR5_3_CTG1",
"HSCHR5_1_CTG1",
"HSCHR5_2_CTG1",
"HSCHR5_6_CTG1",
"HSCHR5_2_CTG1_1",
"HSCHR5_3_CTG1_1",
"HSCHR5_4_CTG1_1",
"HSCHR5_1_CTG5",
"HSCHR5_2_CTG5",
"HSCHR6_MHC_APD_CTG1",
"HSCHR6_1_CTG7",
"HSCHR6_1_CTG6",
"HSCHR6_1_CTG2",
"HSCHR6_1_CTG8",
"HSCHR6_1_CTG9",
"HSCHR6_1_CTG3",
"HSCHR6_1_CTG4",
"HSCHR6_1_CTG5",
"HSCHR7_1_CTG1",
"HSCHR7_2_CTG4_4",
"HSCHR7_1_CTG4_4",
"HSCHR7_1_CTG6",
"HSCHR7_2_CTG6",
"HSCHR7_3_CTG6",
"HSCHR7_2_CTG7",
"HSCHR7_1_CTG7",
"HSCHR8_4_CTG1",
"HSCHR8_2_CTG1",
"HSCHR8_1_CTG1",
"HSCHR8_8_CTG1",
"HSCHR8_3_CTG1",
"HSCHR8_9_CTG1",
"HSCHR8_1_CTG6",
"HSCHR8_1_CTG7",
"HSCHR8_5_CTG7",
"HSCHR8_6_CTG7",
"HSCHR8_4_CTG7",
"HSCHR8_3_CTG7",
"HSCHR8_2_CTG7",
"HSCHR9_1_CTG1",
"HSCHR9_1_CTG2",
"HSCHR9_1_CTG3",
"HSCHR9_1_CTG4",
"HSCHR9_1_CTG5",
"HSCHR10_1_CTG1",
"HSCHR10_1_CTG3",
"HSCHR10_1_CTG2",
"HSCHR10_1_CTG4",
"HSCHR11_1_CTG8",
"HSCHR11_1_CTG6",
"HSCHR11_1_CTG7",
"HSCHR11_1_CTG5",
"HSCHR11_1_CTG1_1",
"HG142_HG150_NOVEL_TEST",
"HG151_NOVEL_TEST",
"HSCHR11_1_CTG3",
"HSCHR11_1_CTG2",
"HSCHR12_1_CTG1",
"HSCHR12_2_CTG2",
"HSCHR12_5_CTG2",
"HSCHR12_1_CTG2",
"HSCHR12_4_CTG2",
"HSCHR12_1_CTG2_1",
"HSCHR12_2_CTG2_1",
"HSCHR12_3_CTG2_1",
"HSCHR12_6_CTG2_1",
"HSCHR12_4_CTG2_1",
"HSCHR12_5_CTG2_1",
"HSCHR12_7_CTG2_1",
"HSCHR13_1_CTG3",
"HSCHR13_1_CTG2",
"HSCHR13_1_CTG6",
"HSCHR13_1_CTG4",
"HSCHR13_1_CTG1",
"HSCHR13_1_CTG5",
"HSCHR14_1_CTG1",
"HSCHR14_7_CTG1",
"HSCHR14_2_CTG1",
"HSCHR14_3_CTG1",
"HSCHR15_1_CTG1",
"HSCHR15_3_CTG3",
"HSCHR15_1_CTG3",
"HSCHR15_1_CTG8",
"HSCHR15_3_CTG8",
"HSCHR15_2_CTG8",
"HSCHR15_5_CTG8",
"HSCHR16_CTG2",
"HSCHR16_4_CTG1",
"HSCHR16_3_CTG1",
"HSCHR16_1_CTG1",
"HSCHR16_1_CTG3_1",
"HSCHR16_2_CTG3_1",
"HSCHR17_1_CTG1",
"HSCHR17_2_CTG2",
"HSCHR17_1_CTG2",
"HSCHR17_7_CTG4",
"HSCHR17_4_CTG4",
"HSCHR17_5_CTG4",
"HSCHR17_1_CTG4",
"HSCHR17_1_CTG5",
"HSCHR17_2_CTG4",
"HSCHR17_8_CTG4",
"HSCHR17_9_CTG4",
"HSCHR17_3_CTG4",
"HSCHR17_1_CTG9",
"HSCHR18_4_CTG1_1",
"HSCHR18_1_CTG1_1",
"HSCHR18_2_CTG1_1",
"HSCHR18_2_CTG2",
"HSCHR18_1_CTG2",
"HSCHR18_1_CTG2_1",
"HSCHR18_2_CTG2_1",
"HSCHR18_3_CTG2_1",
"HSCHR19_5_CTG2",
"HSCHR19_4_CTG2",
"HSCHR19_1_CTG2",
"HSCHR19_2_CTG2",
"HSCHR19_3_CTG2",
"HSCHR19_1_CTG3_1",
"HSCHR19_2_CTG3_1",
"HSCHR19_3_CTG3_1",
"HSCHR19LRC_COX1_CTG3_1",
"HSCHR20_1_CTG1",
"HSCHR20_1_CTG2",
"HSCHR20_1_CTG4",
"HSCHR20_1_CTG3",
"HSCHR21_1_CTG1_1",
"HSCHR21_8_CTG1_1",
"HSCHR21_6_CTG1_1",
"HSCHR21_2_CTG1_1",
"HSCHR21_3_CTG1_1",
"HSCHR21_4_CTG1_1",
"HSCHR21_5_CTG2",
"HSCHR22_1_CTG3",
"HSCHR22_1_CTG6",
"HSCHR22_1_CTG7",
"HSCHR22_1_CTG4",
"HSCHR22_1_CTG5",
"HSCHR22_1_CTG2",
"HSCHR22_1_CTG1",
"HSCHRX_1_CTG3",
"HSCHRX_2_CTG12",
"HSCHR1_ALT2_1_CTG32_1",
"HSCHR2_2_CTG7",
"HSCHR2_2_CTG15",
"HSCHR3_3_CTG3",
"HSCHR4_6_CTG12",
"HSCHR5_1_CTG1_1",
"HSCHR5_3_CTG5",
"HSCHR6_MHC_COX_CTG1",
"HSCHR7_2_CTG1",
"HSCHR8_6_CTG1",
"HSCHR8_5_CTG1",
"HSCHR11_2_CTG1",
"HSCHR11_2_CTG1_1",
"HSCHR12_3_CTG2",
"HSCHR15_2_CTG3",
"HSCHR15_4_CTG8",
"HSCHR17_2_CTG1",
"HSCHR17_3_CTG2",
"HSCHR17_10_CTG4",
"HSCHR17_6_CTG4",
"HSCHR17_2_CTG5",
"HSCHR18_ALT21_CTG2_1",
"HSCHR18_ALT2_CTG2_1",
"HSCHR19LRC_COX2_CTG3_1",
"HSCHR22_2_CTG1",
"HSCHRX_2_CTG3",
"HSCHR3_4_CTG3",
"HSCHR4_7_CTG12",
"HSCHR6_MHC_DBB_CTG1",
"HSCHR8_7_CTG1",
"HSCHR11_3_CTG1",
"HSCHR19LRC_LRC_I_CTG3_1",
"HSCHR22_3_CTG1",
"HSCHR3_5_CTG3",
"HSCHR6_MHC_MANN_CTG1",
"HSCHR19LRC_LRC_J_CTG3_1",
"HSCHR3_6_CTG3",
"HSCHR6_MHC_MCF_CTG1",
"HSCHR19LRC_LRC_S_CTG3_1",
"HSCHR3_7_CTG3",
"HSCHR6_MHC_QBL_CTG1",
"HSCHR19LRC_LRC_T_CTG3_1",
"HSCHR3_8_CTG3",
"HSCHR6_MHC_SSTO_CTG1",
"HSCHR19LRC_PGF1_CTG3_1",
"HSCHR6_8_CTG1",
"HSCHR19LRC_PGF2_CTG3_1",
"HSCHR19_4_CTG3_1",
"HSCHR19KIR_FH15_B_HAP_CTG3_1",
"HSCHR19KIR_G085_A_HAP_CTG3_1",
"HSCHR19KIR_G085_BA1_HAP_CTG3_1",
"HSCHR19KIR_G248_A_HAP_CTG3_1",
"HSCHR19KIR_G248_BA2_HAP_CTG3_1",
"HSCHR19KIR_GRC212_AB_HAP_CTG3_1",
"HSCHR19KIR_GRC212_BA1_HAP_CTG3_1",
"HSCHR19KIR_LUCE_A_HAP_CTG3_1",
"HSCHR19KIR_LUCE_BDEL_HAP_CTG3_1",
"HSCHR19KIR_RSH_A_HAP_CTG3_1",
"HSCHR19KIR_RSH_BA2_HAP_CTG3_1",
"HSCHR19KIR_T7526_A_HAP_CTG3_1",
"HSCHR19KIR_T7526_BDEL_HAP_CTG3_1",
"HSCHR19KIR_ABC08_A1_HAP_CTG3_1",
"HSCHR19KIR_ABC08_AB_HAP_C_P_CTG3_1",
"HSCHR19KIR_ABC08_AB_HAP_T_P_CTG3_1",
"HSCHR19KIR_FH05_A_HAP_CTG3_1",
"HSCHR19KIR_FH05_B_HAP_CTG3_1",
"HSCHR19KIR_FH06_A_HAP_CTG3_1",
"HSCHR19KIR_FH06_BA1_HAP_CTG3_1",
"HSCHR19KIR_FH08_A_HAP_CTG3_1",
"HSCHR19KIR_FH08_BAX_HAP_CTG3_1",
"HSCHR19KIR_FH13_A_HAP_CTG3_1",
"HSCHR19KIR_FH13_BA2_HAP_CTG3_1",
"HSCHR19KIR_FH15_A_HAP_CTG3_1",
"HSCHR19KIR_RP5_B_HAP_CTG3_1")

.circ_seqs <- "MT"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Homo sapiens",
        species="Human",
        provider="NCBI",
        provider_version="GRCh38",
        release_date="2013-12-17",
        release_name="Genome Reference Consortium Human Build 38",
        source_url="ftp://ftp.ncbi.nlm.nih.gov/genbank/genomes/Eukaryotes/vertebrates_mammals/Homo_sapiens/GRCh38/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Hsapiens"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

