\name{BSgenome.Hsapiens.1000genomes.hs37d5}
\docType{package}

\alias{BSgenome.Hsapiens.1000genomes.hs37d5-package}
\alias{BSgenome.Hsapiens.1000genomes.hs37d5}
\alias{hs37d5}

\title{1000genomes Reference Genome Sequence (hs37d5)}

\description{
  Full 1000genomes Phase2 Reference Genome Sequence (hs37d5), based on NCBI GRCh37.
}

\note{
  This BSgenome data package was made from the following source data file:

  \url{ftp://ftp.1000genomes.ebi.ac.uk/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz}

  The genome is composed of:
  \itemize{
    \item Integrated reference sequence from the GRCh37 primary assembly
    (chromosomal plus unlocalized and unplaced contigs)
    \item The rCRS mitochondrial sequence (AC:NC_012920)
    \item Human herpesvirus 4 type 1 (AC:NC_007605)
    \item Concatenated decoy sequences (hs37d5cs.fa.gz)
  }

  For details, please see
  \url{ftp://ftp.1000genomes.ebi.ac.uk/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/README_human_reference_20110707}.
  
}

\author{Julian Gehring <julian.gehring@embl.de>}

\seealso{
  \itemize{
    \item \link[BSgenome]{BSgenome} objects and the
          \code{\link[BSgenome]{available.genomes}} function
          in the \pkg{BSgenome} software package.
    \item \link[Biostrings]{DNAString} objects in the \pkg{Biostrings}
          package.
    \item The BSgenomeForge vignette (\code{vignette("BSgenomeForge")})
          in the \pkg{BSgenome} software package for how to make a BSgenome
          data package.
  }
}

\examples{
BSgenome.Hsapiens.1000genomes.hs37d5
genome <- BSgenome.Hsapiens.1000genomes.hs37d5
seqlengths(genome)
}

\keyword{package}
\keyword{data}
