.pkgname <- "BSgenome.Hsapiens.1000genomes.hs37d5"

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package = pkgname,
                                   lib.loc = libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism = "Homo sapiens",
        species = "Human",
        provider = "1000genomes",
        provider_version = "hs37d5",
        release_date = "2011-07-07",
        release_name = "hs37d5",
        source_url = "ftp://ftp.1000genomes.ebi.ac.uk/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
        seqnames = NULL,
        circ_seqs = "MT",
        mseqnames = NULL,
        seqs_pkgname = pkgname,
        seqs_dirpath = extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir = ns)
    namespaceExport(ns, objname)

    old_objname <- "hs37d5"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}
