###
###

.pkgname <- "BSgenome.Gaculeatus.UCSC.gasAcu1"

.seqnames <- paste("chr", c("I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV", "XVI", "XVII", "XVIII", "XIX", "XX", "XXI", "M", "Un"), sep="")

.circ_seqs <- "chrM"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Gasterosteus aculeatus",
        species="Stickleback",
        provider="UCSC",
        provider_version="gasAcu1",
        release_date="Feb. 2006",
        release_name="Broad Release 1.0",
        source_url="http://hgdownload.cse.ucsc.edu/goldenPath/gasAcu1/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Gaculeatus"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

