\name{BSgenome.Dvirilis.Ensembl.dvircaf1}
\docType{package}

\alias{BSgenome.Dvirilis.Ensembl.dvircaf1-package}
\alias{BSgenome.Dvirilis.Ensembl.dvircaf1}
\alias{Dvirilis}

\title{Full genome sequences for Drosophila virilis (assembly dvir_caf1)}

\description{
  Full genome sequences for Drosophila virilis (assembly dvir_caf1, GenBank assembly accession GCA_000005245.1) as provided by Ensembl and stored in Biostrings objects.
}

\details{
  
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
Drosophila_virilis.dvir_caf1.dna.toplevel.fa.gz, downloaded from ftp://ftp.ensemblgenomes.org/pub/release-46/metazoa/fasta/drosophila_virilis/dna/ and converted to 2bit format on March 2020
  }

  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the \pkg{BSgenome}
  software package for how to make a BSgenome data package.
}

\author{The Bioconductor Dev Team}

\seealso{
  \itemize{
    \item \link[BSgenome]{BSgenome} objects and the
          \code{\link[BSgenome]{available.genomes}} function
          in the \pkg{BSgenome} software package.
    \item \link[Biostrings]{DNAString} objects in the \pkg{Biostrings}
          package.
    \item The BSgenomeForge vignette (\code{vignette("BSgenomeForge")})
          in the \pkg{BSgenome} software package for how to make a BSgenome
          data package.
  }
}

\examples{
BSgenome.Dvirilis.Ensembl.dvircaf1
genome <- BSgenome.Dvirilis.Ensembl.dvircaf1
head(seqlengths(genome))
genome$scaffold_13049  # same as genome[["scaffold_13049"]]

## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
