###
###

.pkgname <- "BSgenome.Dvirilis.Ensembl.dvircaf1"

.seqnames <- NULL

.circ_seqs <- character(0)

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Drosophila virilis",
        common_name="",
        provider="Ensembl",
        provider_version="dvir_caf1",
        release_date="Aug. 2005",
        release_name="dvir_caf1",
        source_url="ftp://ftp.ensemblgenomes.org/pub/release-46/metazoa/fasta/drosophila_virilis/dna/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Dvirilis"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

