###
###

.pkgname <- "BSgenome.Creinhardtii.JGI.v5.6"

.seqnames <- NULL

.circ_seqs <- character(0)

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Chlamydomonas reinhardtii",
        common_name="Green algae",
        genome="Creinhardtii_v5_6",
        provider="JGI",
        release_date="2017/6/12",
        source_url="https://phytozome-next.jgi.doe.gov/info/Creinhardtii_v5_6",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Creinhardtii"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

