\name{BSgenome.Cjacchus.UCSC.calJac4}
\docType{package}

\alias{BSgenome.Cjacchus.UCSC.calJac4-package}
\alias{BSgenome.Cjacchus.UCSC.calJac4}
\alias{Cjacchus}

\title{Full genome sequences for Callithrix jacchus (UCSC version calJac4)}

\description{
  Full genome sequences for Callithrix jacchus (Marmoset) as provided by UCSC (calJac4, May 2020) and wrapped in a BSgenome object.
}

\details{
  
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
calJac4.2bit from http://hgdownload.cse.ucsc.edu/goldenPath/calJac4/bigZips/
  }

  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the \pkg{BSgenome}
  software package for how to make a BSgenome data package.
}

\author{The Bioconductor Dev Team}

\seealso{
  \itemize{
    \item \link[BSgenome]{BSgenome} objects and the
          \code{\link[BSgenome]{available.genomes}} function
          in the \pkg{BSgenome} software package.
    \item \link[Biostrings]{DNAString} objects in the \pkg{Biostrings}
          package.
    \item The BSgenomeForge vignette (\code{vignette("BSgenomeForge")})
          in the \pkg{BSgenome} software package for how to make a BSgenome
          data package.
  }
}

\examples{
BSgenome.Cjacchus.UCSC.calJac4
genome <- BSgenome.Cjacchus.UCSC.calJac4
head(seqlengths(genome))
genome$chr1  # same as genome[["chr1"]]

## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
