###
###

.pkgname <- "BSgenome.Cjacchus.UCSC.calJac4"

.seqnames <- NULL

.circ_seqs <- "chrM"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Callithrix jacchus",
        common_name="Marmoset",
        genome="calJac4",
        provider="UCSC",
        release_date="May 2020",
        source_url="http://hgdownload.cse.ucsc.edu/goldenPath/calJac4/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Cjacchus"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

