###
###

.pkgname <- "BSgenome.Cjacchus.UCSC.calJac3"

.seqnames <- NULL

.circ_seqs <- NULL

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Callithrix jacchus",
        common_name="Marmoset",
        provider="UCSC",
        provider_version="calJac3",
        release_date="Mar. 2009",
        release_name="WUSTL Callithrix_jacchus-v3.2",
        source_url="http://hgdownload.cse.ucsc.edu/goldenPath/calJac3/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Cjacchus"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

