\name{BSgenome.Carietinum.NCBI.v1}
\docType{package}

\alias{BSgenome.Carietinum.NCBI.v1-package}
\alias{BSgenome.Carietinum.NCBI.v1}
\alias{Carietinum}

\title{Cicer arietinum (Chickpea) full genome (NCBI version ASM33114v1)}

\description{
  Full genome sequences for Cicer arietinum (Chickpea) as provided by
NCBI (ASM33114v1, Jan. 2013) and stored in Biostrings objects
}

\details{
  
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
https://www.ncbi.nlm.nih.gov/assembly/GCF_000331145.1/
  }

  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the \pkg{BSgenome}
  software package for how to make a BSgenome data package.
}

\author{Jose V. Die  <jose.die@uco.es>}

\seealso{
  \itemize{
    \item \link[BSgenome]{BSgenome} objects and the
          \code{\link[BSgenome]{available.genomes}} function
          in the \pkg{BSgenome} software package.
    \item \link[Biostrings]{DNAString} objects in the \pkg{Biostrings}
          package.
    \item The BSgenomeForge vignette (\code{vignette("BSgenomeForge")})
          in the \pkg{BSgenome} software package for how to make a BSgenome
          data package.
  }
}

\examples{
BSgenome.Carietinum.NCBI.v1
genome <- BSgenome.Carietinum.NCBI.v1
head(seqlengths(genome))


## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
