###
###

.pkgname <- "BSgenome.Carietinum.NCBI.v1"

.seqnames <- c(paste0("Ca", 1:8), "Pltd")

.circ_seqs <- "Pltd"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Cicer arietinum",
        common_name="Chickpea",
        provider="NCBI",
        provider_version="ASM33114v1",
        release_date="Jan, 2013",
        release_name="BGI-Shenzhen ASM33114v1",
        source_url="https://www.ncbi.nlm.nih.gov/assembly/GCF_000331145.1/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Carietinum"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

