\name{BSgenome.Athaliana.TAIR.04232008}
\docType{package}

\alias{BSgenome.Athaliana.TAIR.04232008-package}
\alias{BSgenome.Athaliana.TAIR.04232008}
\alias{Athaliana}

\title{Full genome sequences for Arabidopsis thaliana (TAIR version from April 23, 2008)}

\description{
  Full genome sequences for Arabidopsis thaliana as provided by TAIR (snapshot from April 23, 2008) and stored in Biostrings objects.
}

\details{
  
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
all the chr*.fas file from ftp://ftp.arabidopsis.org/home/tair/Sequences/whole_chromosomes/
WARNING: This is where things are today (Oct 1st, 2008) but is probably
NOT aimed to be the permanent URL for the 04232008 snapshot of the genome.
TAIR might update the content of this folder in the future with a new
snapshot and move the 04232008 snapshot to the OLD/ subfolder.
  }

  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the \pkg{BSgenome}
  software package for how to make a BSgenome data package.
}

\author{The Bioconductor Dev Team}

\seealso{
  \itemize{
    \item \link[BSgenome]{BSgenome} objects and the
          \code{\link[BSgenome]{available.genomes}} function
          in the \pkg{BSgenome} software package.
    \item \link[Biostrings]{DNAString} objects in the \pkg{Biostrings}
          package.
    \item The BSgenomeForge vignette (\code{vignette("BSgenomeForge")})
          in the \pkg{BSgenome} software package for how to make a BSgenome
          data package.
  }
}

\examples{
BSgenome.Athaliana.TAIR.04232008
genome <- BSgenome.Athaliana.TAIR.04232008
seqlengths(genome)
genome$chr1  # same as genome[["chr1"]]

## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
