\name{BSgenome.Aofficinalis.NCBI.V1}
\docType{package}

\alias{BSgenome.Aofficinalis.NCBI.V1-package}
\alias{BSgenome.Aofficinalis.NCBI.V1}
\alias{Aofficinalis}

\title{Asparagus officinalis (Garden asparagus) full genome (NCBI version Aspof.V1)}

\description{
  Full genome sequences for Asparagus officinalis (Garden asparagus) as      provided by NCBI (Aspof.V1, Feb. 2017) and stored in Biostrings objects.
}

\details{
  
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
https://www.ncbi.nlm.nih.gov/assembly/GCF_001876935.1/
  }

  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the \pkg{BSgenome}
  software package for how to make a BSgenome data package.
}

\author{Jose V. Die  <jose.die@uco.es>}

\seealso{
  \itemize{
    \item \link[BSgenome]{BSgenome} objects and the
          \code{\link[BSgenome]{available.genomes}} function
          in the \pkg{BSgenome} software package.
    \item \link[Biostrings]{DNAString} objects in the \pkg{Biostrings}
          package.
    \item The BSgenomeForge vignette (\code{vignette("BSgenomeForge")})
          in the \pkg{BSgenome} software package for how to make a BSgenome
          data package.
  }
}

\examples{
BSgenome.Aofficinalis.NCBI.V1
genome <- BSgenome.Aofficinalis.NCBI.V1
head(seqlengths(genome))


## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
