###
###

.pkgname <- "BSgenome.Aofficinalis.NCBI.V1"

.seqnames <- paste0("AsparagusV1_", c(paste0(0,seq(1:9)), 10))

.circ_seqs <- NULL

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Asparagus officinalis",
        common_name="Garden asparagus",
        provider="NCBI",
        provider_version="Aspof.V1",
        release_date="Feb, 2017",
        release_name="GCF_001876935.1",
        source_url="https://www.ncbi.nlm.nih.gov/assembly/GCF_001876935.1/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Aofficinalis"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

