###
###

.pkgname <- "BSgenome.Amellifera.UCSC.apiMel2"

.seqnames <- paste("Group", c(1:16, "Un"), sep="")

.circ_seqs <- NULL

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Apis mellifera",
        species="Honey Bee",
        provider="UCSC",
        provider_version="apiMel2",
        release_date="Jan. 2005",
        release_name="Baylor College of Medicine HGSC v.Amel_2.0",
        source_url="http://hgdownload.cse.ucsc.edu/goldenPath/apiMel2/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Amellifera"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

