\name{BSgenome.Amellifera.NCBI.AmelHAv3.1}
\docType{package}

\alias{BSgenome.Amellifera.NCBI.AmelHAv3.1-package}
\alias{BSgenome.Amellifera.NCBI.AmelHAv3.1}
\alias{Amellifera}

\title{Full genome sequences for Apis mellifera (Amel_HAv3.1)}

\description{
  Full genome sequences for Apis mellifera as provided by NCBI (assembly Amel_HAv3.1, assembly accession GCF_003254395.2) and stored in Biostrings objects.
}

\details{
  
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
GCF_003254395.2_Amel_HAv3.1_genomic.fna.gz from https://ftp.ncbi.nlm.nih.gov/genomes/all/GCF/003/254/395/GCF_003254395.2_Amel_HAv3.1/
  }

  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the \pkg{BSgenome}
  software package for how to make a BSgenome data package.
}

\author{The Bioconductor Dev Team}

\seealso{
  \itemize{
    \item \link[BSgenome]{BSgenome} objects and the
          \code{\link[BSgenome]{available.genomes}} function
          in the \pkg{BSgenome} software package.
    \item \link[Biostrings]{DNAString} objects in the \pkg{Biostrings}
          package.
    \item The BSgenomeForge vignette (\code{vignette("BSgenomeForge")})
          in the \pkg{BSgenome} software package for how to make a BSgenome
          data package.
  }
}

\examples{
BSgenome.Amellifera.NCBI.AmelHAv3.1
genome <- BSgenome.Amellifera.NCBI.AmelHAv3.1
head(seqlengths(genome))
genome[["Group1"]]

## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
