###
###

.pkgname <- "BSgenome.Amellifera.BeeBase.assembly4"

.seqnames <- paste("Group", 1:16, sep="")

.circ_seqs <- NULL

.mseqnames <- "GroupUn"

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Apis mellifera",
        species="Honey Bee",
        provider="BeeBase",
        provider_version="assembly4",
        release_date="Feb. 2008",
        release_name="assembly4",
        source_url="NA",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Amellifera"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

