% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/helper_methods.R
\docType{class}
\name{ZinbModel-class}
\alias{ZinbModel-class}
\alias{ZinbModel}
\alias{show,ZinbModel-method}
\alias{nSamples,ZinbModel-method}
\alias{nFeatures,ZinbModel-method}
\alias{nFactors,ZinbModel-method}
\alias{getX_mu,ZinbModel-method}
\alias{getX_pi,ZinbModel-method}
\alias{getV_mu,ZinbModel-method}
\alias{getV_pi,ZinbModel-method}
\alias{getLogMu,ZinbModel-method}
\alias{getMu,ZinbModel-method}
\alias{getLogitPi,ZinbModel-method}
\alias{getPi,ZinbModel-method}
\alias{getZeta,ZinbModel-method}
\alias{getPhi,ZinbModel-method}
\alias{getTheta,ZinbModel-method}
\alias{getEpsilon_beta_mu,ZinbModel-method}
\alias{getEpsilon_gamma_mu,ZinbModel-method}
\alias{getEpsilon_beta_pi,ZinbModel-method}
\alias{getEpsilon_gamma_pi,ZinbModel-method}
\alias{getEpsilon_W,ZinbModel-method}
\alias{getEpsilon_alpha,ZinbModel-method}
\alias{getEpsilon_zeta,ZinbModel-method}
\alias{getW,ZinbModel-method}
\alias{getBeta_mu,ZinbModel-method}
\alias{getBeta_pi,ZinbModel-method}
\alias{getGamma_mu,ZinbModel-method}
\alias{getGamma_pi,ZinbModel-method}
\alias{getAlpha_mu,ZinbModel-method}
\alias{getAlpha_pi,ZinbModel-method}
\title{Class ZinbModel}
\usage{
\S4method{show}{ZinbModel}(object)

\S4method{nSamples}{ZinbModel}(x)

\S4method{nFeatures}{ZinbModel}(x)

\S4method{nFactors}{ZinbModel}(x)

\S4method{getX_mu}{ZinbModel}(object, intercept = TRUE)

\S4method{getX_pi}{ZinbModel}(object, intercept = TRUE)

\S4method{getV_mu}{ZinbModel}(object, intercept = TRUE)

\S4method{getV_pi}{ZinbModel}(object, intercept = TRUE)

\S4method{getLogMu}{ZinbModel}(object)

\S4method{getMu}{ZinbModel}(object)

\S4method{getLogitPi}{ZinbModel}(object)

\S4method{getPi}{ZinbModel}(object)

\S4method{getZeta}{ZinbModel}(object)

\S4method{getPhi}{ZinbModel}(object)

\S4method{getTheta}{ZinbModel}(object)

\S4method{getEpsilon_beta_mu}{ZinbModel}(object)

\S4method{getEpsilon_gamma_mu}{ZinbModel}(object)

\S4method{getEpsilon_beta_pi}{ZinbModel}(object)

\S4method{getEpsilon_gamma_pi}{ZinbModel}(object)

\S4method{getEpsilon_W}{ZinbModel}(object)

\S4method{getEpsilon_alpha}{ZinbModel}(object)

\S4method{getEpsilon_zeta}{ZinbModel}(object)

\S4method{getW}{ZinbModel}(object)

\S4method{getBeta_mu}{ZinbModel}(object)

\S4method{getBeta_pi}{ZinbModel}(object)

\S4method{getGamma_mu}{ZinbModel}(object)

\S4method{getGamma_pi}{ZinbModel}(object)

\S4method{getAlpha_mu}{ZinbModel}(object)

\S4method{getAlpha_pi}{ZinbModel}(object)
}
\arguments{
\item{object}{an object of class \code{ZinbModel}.}

\item{x}{an object of class \code{ZinbModel}.}

\item{intercept}{logical. Whether to return the intercept (ignored if the
design matrix has no intercept). Default \code{TRUE}}
}
\value{
\code{nSamples} returns the number of samples; \code{nFeatures}
returns the number of features; \code{nFactors} returns the number of latent
factors.
}
\description{
Objects of this class store all the values needed to work with a
zero-inflated negative binomial (ZINB) model, as described in the vignette.
They contain all information to fit a model by penalized maximum likelihood
or simulate data from a model.
}
\details{
For the full description of the model see the model vignette.
  Internally, the slots are checked so that the matrices are of the
  appropriate dimensions: in particular, \code{X}, \code{O_mu}, \code{O_pi},
  and \code{W} need to have \code{n} rows, \code{V} needs to have \code{J}
  rows, \code{zeta} must be of length \code{J}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show(ZinbModel)}: show useful info on the object.

\item \code{nSamples(ZinbModel)}: returns the number of samples.

\item \code{nFeatures(ZinbModel)}: returns the number of features.

\item \code{nFactors(ZinbModel)}: returns the number of latent factors.

\item \code{getX_mu(ZinbModel)}: returns the sample-level design matrix for mu.

\item \code{getX_pi(ZinbModel)}: returns the sample-level design matrix for pi.

\item \code{getV_mu(ZinbModel)}: returns the gene-level design matrix for mu.

\item \code{getV_pi(ZinbModel)}: returns the sample-level design matrix for pi.

\item \code{getLogMu(ZinbModel)}: returns the logarithm of the mean of the non-zero
component.

\item \code{getMu(ZinbModel)}: returns the mean of the non-zero component.

\item \code{getLogitPi(ZinbModel)}: returns the logit-probability of zero.

\item \code{getPi(ZinbModel)}: returns the probability of zero.

\item \code{getZeta(ZinbModel)}: returns the log of the inverse of the dispersion
parameter.

\item \code{getPhi(ZinbModel)}: returns the dispersion parameter.

\item \code{getTheta(ZinbModel)}: returns the inverse of the dispersion parameter.

\item \code{getEpsilon_beta_mu(ZinbModel)}: returns the regularization parameters for
\code{beta_mu}.

\item \code{getEpsilon_gamma_mu(ZinbModel)}: returns the regularization parameters for
\code{gamma_mu}.

\item \code{getEpsilon_beta_pi(ZinbModel)}: returns the regularization parameters for
\code{beta_pi}.

\item \code{getEpsilon_gamma_pi(ZinbModel)}: returns the regularization parameters for
\code{gamma_pi}.

\item \code{getEpsilon_W(ZinbModel)}: returns the regularization parameters for
\code{W}.

\item \code{getEpsilon_alpha(ZinbModel)}: returns the regularization parameters for
\code{alpha}.

\item \code{getEpsilon_zeta(ZinbModel)}: returns the regularization parameters for
\code{zeta}.

\item \code{getW(ZinbModel)}: returns the matrix W of inferred sample-level
covariates.

\item \code{getBeta_mu(ZinbModel)}: returns the matrix beta_mu of inferred parameters.

\item \code{getBeta_pi(ZinbModel)}: returns the matrix beta_pi of inferred parameters.

\item \code{getGamma_mu(ZinbModel)}: returns the matrix gamma_mu of inferred parameters.

\item \code{getGamma_pi(ZinbModel)}: returns the matrix gamma_pi of inferred parameters.

\item \code{getAlpha_mu(ZinbModel)}: returns the matrix alpha_mu of inferred parameters.

\item \code{getAlpha_pi(ZinbModel)}: returns the matrix alpha_pi of inferred parameters.

}}
\section{Slots}{

\describe{
\item{\code{X}}{matrix. The design matrix containing sample-level covariates, one
sample per row.}

\item{\code{V}}{matrix. The design matrix containing gene-level covariates, one gene
per row.}

\item{\code{O_mu}}{matrix. The offset matrix for mu.}

\item{\code{O_pi}}{matrix. The offset matrix for pi.}

\item{\code{which_X_mu}}{integer. Indeces of which columns of X to use in the
regression of mu.}

\item{\code{which_V_mu}}{integer. Indeces of which columns of V to use in the
regression of mu.}

\item{\code{which_X_pi}}{integer. Indeces of which columns of X to use in the
regression of pi.}

\item{\code{which_V_pi}}{integer. Indeces of which columns of V to use in the
regression of pi.}

\item{\code{X_mu_intercept}}{logical. TRUE if X_mu contains an intercept.}

\item{\code{X_pi_intercept}}{logical. TRUE if X_pi contains an intercept.}

\item{\code{V_mu_intercept}}{logical. TRUE if V_mu contains an intercept.}

\item{\code{V_pi_intercept}}{logical. TRUE if V_pi contains an intercept.}

\item{\code{W}}{matrix. The factors of sample-level latent factors.}

\item{\code{beta_mu}}{matrix or NULL. The coefficients of X in the regression of mu.}

\item{\code{gamma_mu}}{matrix or NULL. The coefficients of V in the regression of mu.}

\item{\code{alpha_mu}}{matrix or NULL. The coefficients of W in the regression of mu.}

\item{\code{beta_pi}}{matrix or NULL. The coefficients of X in the regression of pi.}

\item{\code{gamma_pi}}{matrix or NULL. The coefficients of V in the regression of pi.}

\item{\code{alpha_pi}}{matrix or NULL. The coefficients of W in the regression of pi.}

\item{\code{zeta}}{numeric. A vector of log of inverse dispersion parameters.}

\item{\code{epsilon_beta_mu}}{nonnegative scalar. Regularization parameter for
beta_mu}

\item{\code{epsilon_gamma_mu}}{nonnegative scalar. Regularization parameter for
gamma_mu}

\item{\code{epsilon_beta_pi}}{nonnegative scalar. Regularization parameter for
beta_pi}

\item{\code{epsilon_gamma_pi}}{nonnegative scalar. Regularization parameter for
gamma_pi}

\item{\code{epsilon_W}}{nonnegative scalar. Regularization parameter for W}

\item{\code{epsilon_alpha}}{nonnegative scalar. Regularization parameter for alpha
(both alpha_mu and alpha_pi)}

\item{\code{epsilon_zeta}}{nonnegative scalar. Regularization parameter for zeta}

\item{\code{epsilon_min_logit}}{scalar. Minimum regularization parameter for
parameters of the logit model, including the intercept.}
}}

