% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-group-features.R
\name{plotFeatureGroups}
\alias{plotFeatureGroups}
\title{Plot feature groups in the m/z-retention time space}
\usage{
plotFeatureGroups(
  x,
  xlim = numeric(),
  ylim = numeric(),
  xlab = "retention time",
  ylab = "m/z",
  pch = 4,
  col = "#00000060",
  type = "o",
  main = "Feature groups",
  featureGroups = character(),
  ...
)
}
\arguments{
\item{x}{\link{XcmsExperiment} or \code{\link[=XCMSnExp]{XCMSnExp()}} object with grouped features
(i.e. after calling \code{\link[MsFeatures:groupFeatures]{MsFeatures::groupFeatures()}}.}

\item{xlim}{\code{numeric(2)} with the lower and upper limit for the x-axis.}

\item{ylim}{\code{numeric(2)} with the lower and upper limit for the y-axis.}

\item{xlab}{\code{character(1)} with the label for the x-axis.}

\item{ylab}{\code{character(1)} with the label for the y-axis.}

\item{pch}{the plotting character. Defaults to \code{pch = 4} i.e. plotting
features as crosses. See \code{\link[=par]{par()}} for more information.}

\item{col}{color to be used to draw the features. At present only a single
color is supported.}

\item{type}{plotting type (see \code{\link[=par]{par()}}). Defaults to \code{type = "o"} which
draws each feature as a point and connecting the features of the same
feature group with a line.}

\item{main}{\code{character(1)} with the title of the plot.}

\item{featureGroups}{optional \code{character} of feature group IDs to draw only
specified feature group(s). If not provided, all feature groups are
drawn.}

\item{...}{additional parameters to be passed to the \code{lines} function.}
}
\description{
\code{plotFeatureGroups()} visualizes defined feature groups in the m/z by
retention time space. Features are indicated by points with features from
the same feature group being connected by a line. See
\code{\link[MsFeatures:featureGroups]{MsFeatures::featureGroups()}} for details on and options for
feature grouping.
}
\author{
Johannes Rainer
}
