% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-filterFeatures.R
\name{DratioFilter}
\alias{DratioFilter}
\alias{filterFeatures,XcmsResult,DratioFilter-method}
\alias{filterFeatures,SummarizedExperiment,DratioFilter-method}
\title{Filter features based on the dispersion ratio}
\usage{
DratioFilter(
  threshold = 0.5,
  qcIndex = integer(),
  studyIndex = integer(),
  na.rm = TRUE,
  mad = FALSE
)

\S4method{filterFeatures}{XcmsResult,DratioFilter}(object, filter, ...)

\S4method{filterFeatures}{SummarizedExperiment,DratioFilter}(object, filter, assay = 1)
}
\arguments{
\item{threshold}{\code{numeric} value representing the threshold. Features with a
D-ratio \emph{strictly higher} (\code{>}) than this will be removed from the entire
dataset.}

\item{qcIndex}{\code{integer} (or \code{logical}) vector corresponding to the indices
of QC samples.}

\item{studyIndex}{\code{integer} (or \code{logical}) vector corresponding of the
indices of study samples.}

\item{na.rm}{\code{logical} Indicates whether missing values (\code{NA}) should be
removed prior to the calculations.}

\item{mad}{\code{logical} Indicates whether the \emph{Median Absolute Deviation}
(MAD) should be used instead of the standard deviation. This is suggested
for non-gaussian distributed data.}

\item{object}{\code{XcmsExperiment} or \code{SummarizedExperiment}. For an
\code{XcmsExperiment} object, the \code{featureValues(object)} will be evaluated, and
for \code{Summarizedesxperiment} the \code{assay(object, assay)}. The object will be
filtered.}

\item{filter}{The parameter object selecting and configuring the type of
filtering. It can be one of the following classes: \code{\link{RsdFilter}},
\code{\link{DratioFilter}}, \code{\link{PercentMissingFilter}} or \code{\link{BlankFlag}}.}

\item{...}{Optional parameters. For \code{object} being an \code{XcmsExperiment}:
parameters for the \code{\link[=featureValues]{featureValues()}} call.}

\item{assay}{For filtering of \code{SummarizedExperiment} objects only. Indicates
which assay the filtering will be based on. Note that the features for the
entire object will be removed, but the computations are performed on a single
assay. Default is 1, which means the first assay of the \code{object} will
be evaluated.}
}
\value{
For \code{DratioFilter}: a \code{DratioFilter} class. \code{filterFeatures} return
the input object minus the features that did not met the user input threshold
}
\description{
The \code{DratioFilter} class and method enable users to filter features from an
\code{XcmsExperiment} or \code{SummarizedExperiment} object based on the D-ratio or
\emph{dispersion ratio}. This is defined as the standard deviation for QC
samples divided by the standard deviation for biological test samples, for
each feature of the object (Broadhurst et al.).

This \code{filter} is part of the possible dispatch of the generic function
\code{filterFeatures}.  Features \emph{above} (\code{>}) the user-input threshold will be
removed from the entire dataset.
}
\references{
Broadhurst D, Goodacre R, Reinke SN, Kuligowski J, Wilson ID, Lewis MR,
Dunn WB. Guidelines and considerations for the use of system suitability
and quality control samples in mass spectrometry assays applied in
untargeted clinical metabolomic studies. Metabolomics. 2018;14(6):72.
doi: \href{https://doi.org/10.1007/s11306-018-1367-3}{10.1007/s11306-018-1367-3}.
Epub 2018 May 18. PMID: 29805336; PMCID: PMC5960010.
}
\seealso{
Other Filter features in xcms: 
\code{\link{BlankFlag}},
\code{\link{PercentMissingFilter}},
\code{\link{RsdFilter}}
}
\author{
Philippine Louail
}
\concept{Filter features in xcms}
