% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vissE-package.R
\docType{package}
\name{vissE-package}
\alias{vissE}
\alias{vissE-package}
\title{vissE: Visualising Set Enrichment Analysis Results}
\description{
This package enables the interpretation and analysis of results from a gene set enrichment analysis using network-based and text-mining approaches. Most enrichment analyses result in large lists of significant gene sets that are difficult to interpret. Tools in this package help build a similarity-based network of significant gene sets from a gene set enrichment analysis that can then be investigated for their biological function using text-mining approaches.
}
\details{
This package supports four workflows to enhance gene set enrichment analysis:
\enumerate{
\item Clustering results from a gene set enrichment analysis (e.g. using
limma::fry, singscore or GSEA). The functions required for this analysis
are \code{\link{computeMsigOverlap}}, \code{\link{computeMsigNetwork}} and
\code{\link{plotMsigNetwork}}.
\item Interpreting gene set clusters (identified in the first analysis) by
performing text-mining of gene set names and descriptions. The main
function required to perform text-mining of gene sets is
\code{\link{plotMsigWordcloud}}. Other functions can be used to access
intermmediate results.
\item Visualise gene-level statistics for gene set clusters identified in
the first analysis to link back gene set clusters to the genes of interest.
This can be done using the \code{\link{plotGeneStats}} function.
\item Identifying gene sets similar to a list of genes identified from a DE
analysis using set overlap measures. This can be done using the
\code{\link{characteriseGeneset}} function.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://davislaboratory.github.io/vissE}
  \item Report bugs at \url{https://github.com/DavisLaboratory/vissE/issues}
}

}
\author{
\strong{Maintainer}: Dharmesh D. Bhuva \email{bhuva.d@wehi.edu.au} (\href{https://orcid.org/0000-0002-6398-9157}{ORCID})

Other contributors:
\itemize{
  \item Ahmed Mohamed \email{mohamed.a@wehi.edu.au} [contributor]
}

}
\keyword{internal}
