% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array_coord_utils.R
\name{.refine_fit}
\alias{.refine_fit}
\title{Return array coordinates fit to nearest spot with associated error}
\usage{
.refine_fit(x, y, INTERVAL_X, INTERVAL_Y)
}
\arguments{
\item{x}{\code{numeric()} vector giving "ideal" array coordinates given every
spot's transformed pixel coordinates.}

\item{y}{Same as x, though y must represent ideal array columns iff x
represents array rows, and vice versa.}

\item{INTERVAL_X}{\code{numeric(1)} giving pixel distance between coordinate
units used for \code{x} (e.g. if x represents ideal \code{array_col} values,
\code{INTERVAL_X} represents pixel distance between spot columns).}

\item{INTERVAL_Y}{\code{numeric(1)} giving pixel distance between coordinate
units used for \code{y}.}
}
\value{
A \code{list} consisting of 3 unnamed \code{numeric()} vectors:
rounded \code{x}, rounded \code{y}, and the Euclidean distance in pixels from
rounding both \code{x} and \code{y}.
}
\description{
First, values of \code{x} are rounded to the nearest integer. Then, values
of \code{y} are rounded to the nearest valid integer under the constraint
that coordinates for x and y must be both odd or both even. These rounded
values are returned, along with the Euclidean distance needed to move x and
y from their original, non-integer values to their rounded values.
}
\author{
Nicholas J. Eagles
}
\keyword{internal}
