% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_meme.R
\name{run_meme}
\alias{run_meme}
\title{Run MEME from within R.}
\usage{
run_meme(target.sequences, output = NULL, overwrite.dir = FALSE,
  control.sequences = NULL, weights = NULL, text = FALSE, brief = 1000,
  objfun = "classic", test = NULL, use_llr = FALSE, shuf = 2,
  hsfrac = NULL, cefrac = NULL, searchsize = NULL, norand = FALSE,
  csites = 1000, seed = 0, alph = NULL, revcomp = FALSE, pal = FALSE,
  mod = "zoops", nmotifs = 3, evt = NULL, nsites = NULL,
  minsites = NULL, maxsites = NULL, wnsites = 0.8, w = NULL,
  minw = 8, maxw = 50, allw = NULL, nomatrim = FALSE, wg = 11,
  ws = 1, noendgaps = FALSE, bfile = NULL, markov_order = 0,
  psp = NULL, maxiter = 50, distance = 0.001, prior = NULL, b = NULL,
  plib = NULL, spfuzz = NULL, spmap = NULL, cons = NULL, p = NULL,
  maxsize = NULL, maxtime = NULL, wd = getwd(), logfile = paste0(wd,
  "/memerun.log"), readsites = TRUE, echo = FALSE, verbose = 1,
  timeout = Inf, bin = getOption("meme.bin"))
}
\arguments{
\item{target.sequences}{\code{\link{XStringSet}} List of sequences to get motifs from.}

\item{output}{\code{character(1)} Name of the output folder. If \code{NULL}, MEME
output will be deleted.}

\item{overwrite.dir}{\code{logical(1)} If \code{output} is set but already exists,
allow over-writing.}

\item{control.sequences}{\code{\link{XStringSet}} List of negative sequences. Only
used if \code{objfun = c("de", "se")}.}

\item{weights}{\code{numeric} Vector of numbers between 0 and 1, representing
sequence weights.}

\item{text}{\code{logical(1)} [MEME]}

\item{brief}{\code{numeric(1)} [MEME]}

\item{objfun}{\code{character(1)} [MEME]}

\item{test}{\code{character(1)} [MEME]}

\item{use_llr}{\code{logical(1)} [MEME]}

\item{shuf}{\code{numeric(1)} [MEME]}

\item{hsfrac}{\code{numeric(1)} [MEME]}

\item{cefrac}{\code{numeric(1)} [MEME]}

\item{searchsize}{\code{numeric(1)} [MEME]}

\item{norand}{\code{logical(1)} [MEME]}

\item{csites}{\code{numeric(1)} [MEME]}

\item{seed}{\code{numeric(1)} [MEME]}

\item{alph}{\code{character(1)} [MEME] Note: custom alphabet definition files can
be created using \code{\link[=meme_alph]{meme_alph()}}.}

\item{revcomp}{\code{logical(1)} [MEME]}

\item{pal}{\code{logical(1)} [MEME]}

\item{mod}{\code{character(1)} [MEME]}

\item{nmotifs}{\code{numeric(1)} [MEME]}

\item{evt}{\code{numeric(1)} [MEME]}

\item{nsites}{\code{numeric(1)} [MEME]}

\item{minsites}{\code{numeric(1)} [MEME]}

\item{maxsites}{\code{numeric(1)} [MEME]}

\item{wnsites}{\code{numeric(1)} [MEME]}

\item{w}{\code{numeric(1)} [MEME]}

\item{minw}{\code{numeric(1)} [MEME]}

\item{maxw}{\code{numeric(1)} [MEME]}

\item{allw}{\code{numeric(1)} [MEME]}

\item{nomatrim}{\code{logical(1)} [MEME]}

\item{wg}{\code{numeric(1)} [MEME]}

\item{ws}{\code{numeric(1)} [MEME]}

\item{noendgaps}{\code{logical(1)} [MEME]}

\item{bfile}{\code{character(1)} [MEME]}

\item{markov_order}{\code{numeric(1)} [MEME]}

\item{psp}{\code{character(1)} [MEME]}

\item{maxiter}{\code{numeric(1)} [MEME]}

\item{distance}{\code{numeric(1)} [MEME]}

\item{prior}{\code{character(1)} [MEME]}

\item{b}{\code{numeric(1)} [MEME]}

\item{plib}{\code{character(1)} [MEME]}

\item{spfuzz}{\code{numeric(1)} [MEME]}

\item{spmap}{\code{character(1)} [MEME]}

\item{cons}{\code{character(1)} [MEME]}

\item{p}{\code{numeric(1)} [MEME]}

\item{maxsize}{\code{numeric(1)} [MEME]}

\item{maxtime}{\code{numeric(1)} [MEME]}

\item{wd}{\code{character(1)} Working directory to run MEME in.}

\item{logfile}{\code{character(1)} File to dump MEME stderr. If \code{NULL}, no logs
will be saved.}

\item{readsites}{\code{logical(1)} Read sites from MEME output (from \code{\link[=read_meme]{read_meme()}}).}

\item{echo}{\code{logical(1)} Dump MEME output to console.}

\item{verbose}{\code{numeric(1)} Set \code{verbose = 0} to quiet \code{\link[=run_meme]{run_meme()}}.}

\item{timeout}{\code{numeric(1)} Stop MEME program past \code{timeout} (seconds). See
\code{\link[processx:run]{processx::run()}}.}

\item{bin}{\code{character(1)} Location of MEME binary. Alternatively, set this
via \code{options(meme.bin = '/path/to/meme/bin')}.}
}
\value{
\code{list} The output file is read with \code{\link[=read_meme]{read_meme()}}.
}
\description{
De novo motif discovery via MEME. For a detailed description of the command,
see \url{http://meme-suite.org/doc/meme.html}. For a brief description of
the command parameters, call \code{run_meme()} without any arguments. Parameters in
\code{\link[=run_meme]{run_meme()}} which are directly taken from the MEME program are tagged with
[MEME]. This function requires that the \pkg{processx} package be installed
separately.
}
\examples{
\dontrun{
## To check that you are properly linking to the binary:
run_meme()
}

}
\references{
Bailey TL, Elkan C (1994). “Fitting a mixture model by expectation
maximization to discover motifs in biopolymers.” \emph{Proceedings of
the Second International Conference on Intelligent Systems for
Molecular Biology}, \strong{2}, 28-36.
}
\seealso{
\code{\link[=read_meme]{read_meme()}}, \code{\link[=create_sequences]{create_sequences()}}, \code{\link[=shuffle_sequences]{shuffle_sequences()}},
\code{\link[processx:run]{processx::run()}}
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
