% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEstimate_methods.R
\name{getEstimate}
\alias{getEstimate}
\alias{getEstimate,uwmwRes-method}
\title{Extract logor, or, odds and percentages from a uwmwRes object}
\usage{
\S4method{getEstimate}{uwmwRes}(
  x,
  esttype = c("logor", "or", "logodds", "odds", "p"),
  se.fit = (esttype \%in\% c("logor", "logodds")),
  ci = TRUE,
  drop = TRUE
)
}
\arguments{
\item{x}{an object of the clas uwmwRes}

\item{esttype}{a character string indicating the measure you want to extract.
It can take the values \code{logor} for the log odds ratio, \code{or} for
the odds ratios, \code{logodds} for the log odds, \code{odds} for the odds
or \code{p} for the percentages.}

\item{se.fit}{logical value indicating whether the standard errors of the
logor or the log odds should be returned as well. Ignored when type has a
value different from \code{logor} or \code{logodds}.
Note that you can also use the accessor \code{\link{se}} to
get only the standard errors.}

\item{ci}{numerical value indicating the confidence interval
(0.95 is 95\% confidence interval). If set to TRUE, the 95% confidence
interval is returned. If set to NULL, no confidence interval is returned.}

\item{drop}{a logical value. If set to \code{TRUE} and neither \code{se} nor
\code{ci} is calculated, the function returns a vector instead of
an uwmwEstimate object.}
}
\value{
In general, a \code{\link{uwmwEstimate}} object with the
requested estimate. See \code{\link{uwmwEstimate}} for details.
In case \code{drop=TRUE} and neither the standard error nor
the confidence interval is calculated, a numeric named vector.
}
\description{
With this function you can extract the modelled (log) odds ratio, odds or
percentages that represent the chance on differential expression as
estimated by the uWMW function. It also allows to extract either the
standard error of or the confidence interval around the estimates.
See Details for more explanation.
}
\details{
The function can only calculate standard errors for the log OR and
the log odds. In all other cases, \code{se.fit} is ignored. The function
takes into account a possible ordering in the object
(see also \code{\link[unifiedWMWqPCR:sort_uwmwRes]{sort}}). So take into account that you
get the estimates in the specified order. In case you want this different,
either use the function \code{\link{unorder}} on the object first,
or check if any of the \code{\link{uwmw_Accessors}} can help you out.

The argument \code{se.fit} is mainly to be used to save calculation time.
Normally there's no need to set it to \code{FALSE}.
}
\examples{
data(NBmat)
NBtest <- uWMW(NBmat, groups=NBgroups)
getEstimate(NBtest,'logodds')
getEstimate(NBtest,'odds',ci=0.9)

}
