#' Unified Wilcoxon-Mann Whitney Test for qPCR data.
#'
#' This package allows you to carry out the unified Wilcoxon-Mann Whitney
#' Test for qPCR data. If you use this package for research purposes,
#' please cite the following article:
#'
#' De Neve, Jan; Meys, Joris; Ottoy, Jean-Pierre; Clement, Lieven and Thas,
#' Olivier. "UnifiedWMWqPCR: The unified Wilcoxon-Mann-Whitney test for
#' analyzing RT-qPCR data in R." Bioinformatics(2014): Vol.30, Issue 17,
#' pp.2494-2495.
#'
#' Or see \code{citation("unifiedWMWqPCR")}
#'
#' @import methods
#' @importClassesFrom limma MArrayLM
#'
#' @name unifiedWMWqPCR-package
#' @rdname unifiedWMWqPCR-package
#' @aliases unifiedWMWqPCR uWMWqPCR
"_PACKAGE"
