% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildInput.R
\name{buildInput}
\alias{buildInput}
\title{Build input file}
\usage{
buildInput(
  geneList,
  genome,
  type_bam,
  bamList,
  outDir,
  type_input,
  MAPQ.min = 1,
  base.quality = 1
)
}
\arguments{
\item{geneList}{a text file, named with .txt extension,
containing HGNC official gene name(s) one per row.}

\item{genome}{(char) reference genome, hg19 or hg38}

\item{type_bam}{(char) chromosome notation of their BAM file(s). Use "number"
or "chr".  In the BAM file, the number option refers to 1, 2, ..., X,.M
chromosome notation, while the chr option refers to chr1, chr2, ... chrX,
chrM chromosome notation.}

\item{bamList}{a text file, named with .list extension,
containing the absolute paths to BAM file(s) one per row.}

\item{outDir}{(char) directory where pileup output will be stored}

\item{type_input}{(char) type of input target. Use "target" or "genes". If
you use a list of gene names use "genes", if you use a target bed use "target".}

\item{MAPQ.min}{(integer) minimum MAPQ value for an alignment
to be included in output file.}

\item{base.quality}{(integer) minimum QUAL value for each
nucleotide in an alignment.}
}
\value{
Two file: a file.bed containing tab-separated specifications of
genomic coordinates (chromosome, start position, end position),
the coverage value, and the reference:alternate allele counts for each position
and a file.txt with statistical summary of coverage
}
\description{
Function to build input file for unCOVERAPP when the number
of genes to analyze is > 50.
}
\examples{
gene.list<- system.file("extdata", "mygene.txt", package = "uncoverappLib")

bam_example <- system.file("extdata", "example_POLG.bam",
package = "uncoverappLib")
cat(bam_example, file = "bam.list", sep = "\n")
temp_dir=tempdir()
buildInput(geneList= gene.list, genome= "hg19", type_bam= "chr",
bamList= "bam.list",type_input="genes", outDir= temp_dir)

}
