% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uSort_preProcess.R
\name{uSORT_preProcess}
\alias{uSORT_preProcess}
\title{A data loading and pre-processing function}
\usage{
uSORT_preProcess(exprs_file, log_transform = TRUE, remove_outliers = TRUE,
  lod = 1)
}
\arguments{
\item{exprs_file}{Input file name in txt format, with rownames of cells and colnames of genes.}

\item{log_transform}{Boolean, if TRUE log transform the data.}

\item{remove_outliers}{Boolean, if TRUE remove the outliers.}

\item{lod}{A value of limit of detection in the unit of TPM/CPM/RPKM. It will be used as the starting value
for outlier cell detection and the basis for removing scarce genes.}
}
\value{
A list containing \code{exprs_raw}(data frame) and \code{exprs_log_trimed}(data.frame).
}
\description{
A data loading and pre-processing function which firstly identifies outlier cells and scarcely expressed genes.
}
\examples{
dir <- system.file('extdata', package='uSORT')
file <- list.files(dir, pattern='.txt$', full=TRUE)
exprs <- uSORT_preProcess(exprs_file = file)
}

