% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monocle.R
\name{monocle_wrapper}
\alias{monocle_wrapper}
\title{A wrapper function for Monocle sorting method}
\usage{
monocle_wrapper(log2_exp, expression_data_raw, lod = 1)
}
\arguments{
\item{log2_exp}{An log2 transformed expresssion matrix containing n-rows of cells and m-cols of genes.}

\item{expression_data_raw}{A data frame containing raw expression values, with rownames of cells
and colnames of genes.}

\item{lod}{A value of limit of detection in the unit of TPM/CPM/RPKM.}
}
\value{
A data frame containing single column of ordered sample IDs.
}
\description{
A wrapper function for Monocle sorting method
}
\examples{
set.seed(15)
da <- iris[sample(150, 150, replace = FALSE), ]
rownames(da) <- paste0('spl_',seq(1,nrow(da)))
d <- da[,1:4]
dl <- da[,5,drop=FALSE]
#res <- monocle_wrapper(log2_exp = d, expression_data_raw = d)
#dl <- dl[match(res,rownames(dl)),]
#annot <- data.frame(id = seq(1,length(res)), label=dl, stringsAsFactors = FALSE)
#ggplot(annot, aes(x=id, y=id, colour = label)) + geom_point() + theme_bw()
}

