% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mahRain.R
\name{.classwiseMahalanobisRain}
\alias{.classwiseMahalanobisRain}
\title{Fuzzy clusters by bivariate normal distributions.}
\usage{
.classwiseMahalanobisRain(droplets, cl, maxDistance = 30, classCol = "class")
}
\arguments{
\item{droplets}{A data frame of droplets with \code{Ch1.Amplitude} and
\code{Ch2.Amplitude} columns, as well as a class column (see the parameter
\code{classCol}).}

\item{cl}{The class to focus on. This should be either "NN", "NP", "PN" or
"PP".}

\item{maxDistance}{An integer corresponding to the maximum Mahalanobis
distance for which we will consider points to be members of the class, i.e.
this is the level outside of which we consider droplets to be too far from
the cluster.}

\item{classCol}{The column (name or number) from \code{droplets}
representing the class.}
}
\value{
A factor corresponding to the class column with \code{Rain} entries
added for the class \code{cl}.
}
\description{
Assume that the class \code{cl} is bivariate normally distributed. This
method adds fuzziness to the class. Other classes are not changed.
}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
