% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{score_sequences}
\alias{score_sequences}
\title{Score Sequences with PWM}
\usage{
score_sequences(sequences, pwm)
}
\arguments{
\item{sequences}{list of sequences}

\item{pwm}{position weight matrix}
}
\value{
list of PWM scores for each sequence
}
\description{
C++ implementation of PWM scoring algorithm
}
\examples{
motif <- get_motif_by_id("M178_0.6")[[1]]
sequences <- c("CAACAGCCUUAAUU", "CAGUCAAGACUCC", "CUUUGGGGAAU",
               "UCAUUUUAUUAAA", "AAUUGGUGUCUGGAUACUUCCCUGUACAU",
               "AUCAAAUUA", "UGUGGGG", "GACACUUAAAGAUCCU",
               "UAGCAUUAACUUAAUG", "AUGGA", "GAAGAGUGCUCA", "AUAGAC",
               "AGUUC", "CCAGUAA")
seq_char_vectors <- lapply(sequences, function(seq) {
  unlist(strsplit(seq, ""))
})
score_sequences(seq_char_vectors, as.matrix(get_motif_matrix(motif)))

}
