% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TranscriptionDataSet-generics.R,
%   R/TranscriptionDataSet-methods.R
\docType{methods}
\name{exportCoverage}
\alias{exportCoverage}
\alias{exportCoverage,TranscriptionDataSet-method}
\title{exportCoverage}
\usage{
exportCoverage(
  object,
  file,
  type,
  strand,
  color,
  filter.by.coverage.cutoff = FALSE,
  coverage.cutoff = NULL,
  rpm = FALSE,
  total.reads
)

\S4method{exportCoverage}{TranscriptionDataSet}(
  object,
  file,
  type,
  strand,
  color,
  filter.by.coverage.cutoff = FALSE,
  coverage.cutoff = NULL,
  rpm = FALSE,
  total.reads
)
}
\arguments{
\item{object}{A \code{\link{TranscriptionDataSet}} object.}

\item{file}{\code{Character}. A file name.}

\item{type}{\code{Character}. Track type, either "bigWig" or "bedGraph".
Default: "bedGraph".}

\item{strand}{\code{Character}. The strand to create a track for.
One of ["+", "-"].}

\item{color}{Object of class "integer" representing the track color
(as from col2rgb). Only works with tracks of type "bedGraph". Default:
c(0L, 0L, 255L).}

\item{filter.by.coverage.cutoff}{\code{Logical}. Whether to discard regions
with low fragment coverage, representing expression noise from the
resulting track. Default: FALSE.}

\item{coverage.cutoff}{\code{Numeric}. A cutoff value to discard regions with
the low fragment coverage, representing expression noise. By default,
the value stored in the \code{coverageCutoff} slot of the supplied object
is used. The optimal cutoff value can be calculated by
\code{\link{estimateBackground}} function call. Default: NULL.}

\item{rpm}{\code{Logical}. Whether to perform normalization ('Reads Per
Million'). Default: FALSE.}

\item{total.reads}{\code{Numeric}. Total number of reads used for
normalization. By default, the total number of
reads stored in the provided \code{\link{TranscriptionDataSet}} object is
used.}
}
\value{
A file in either
    \href{https://genome.ucsc.edu/goldenPath/help/bigWig.html}{BigWig} or
    \href{http://genome.ucsc.edu/goldenpath/help/bedgraph.html}{bedGraph}
    format.
}
\description{
RNA-seq coverage profiles for both forward and reverse DNA strand can
be visualized separately in the
\href{https://genome.ucsc.edu/}{UCSC genome browser} using \code{exportCoverage}.
This function can generate tracks in
\href{https://genome.ucsc.edu/goldenPath/help/bigWig.html}{BigWig} and
\href{http://genome.ucsc.edu/goldenpath/help/bedgraph.html}{bedGraph} formats,
which can be uploaded to the genome browser as custom tracks.
}
\details{
There is an option to filter coverage profiles by the coverage cutoff
    value, either estimated for a specific FDR via
    \code{\link{estimateBackground}} or a user specified value. By default, the
    coverage cutoff value stored in the \code{\link{TranscriptionDataSet}} object
    is used. In order to make an informed decision about a proper FDR level, it
    is useful to explore the output at different FDR levels and determine the
    optimal cutoff value.
}
\examples{
### Load TranscriptionDataSet object
data(tds)

### Look at the coverage profile of the regions expressed above the background level
# exportCoverage(object = tds, file = "plus.bg", type = "bedGraph", strand = "+",
# filter.by.coverage.cutoff = TRUE, coverage.cutoff = 3, rpm = FALSE)

### Or check the raw coverage (all expressed regions)
# exportCoverage(object = tds, file = "plus_raw.bg", type = "bedGraph",
# strand = "+", filter.by.coverage.cutoff = FALSE, rpm = FALSE)

}
\seealso{
\code{\link{estimateBackground}}
    \href{https://genome.ucsc.edu/}{UCSC genome browser}
    \href{https://genome.ucsc.edu/goldenPath/help/bigWig.html}{BigWig}
}
\author{
Armen R. Karapetyan
}
