% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importScSeqScore.R
\name{importScSeqScore}
\alias{importScSeqScore}
\title{plot tracks for single cell RNAseq}
\usage{
importScSeqScore(
  object,
  files,
  samplenames,
  ...,
  txdb,
  gene,
  id,
  idents,
  gr,
  color,
  withCoverageTrack = TRUE,
  flag = scanBamFlag(isSecondaryAlignment = FALSE, isUnmappedQuery = FALSE,
    isNotPassingQualityControls = FALSE, isSupplementaryAlignment = FALSE)
)
}
\arguments{
\item{object}{Seurat object.}

\item{files}{bam file to be scanned.}

\item{samplenames}{sample names for files.}

\item{...}{parameters used by \link[GenomicAlignments:readGAlignments]{readGAlignmentsList} 
or \link[GenomicAlignments]{readGAlignments}}

\item{txdb}{TxDb object for gene model.}

\item{gene}{Gene name to plot. (row value)}

\item{id}{The id of gene used in txdb.}

\item{idents}{indentity class to define the groups to plot. (column value)}

\item{gr}{GRanges object to define the ploting region.}

\item{color}{vector of colors used in heatmap.}

\item{withCoverageTrack}{plot coverage track or not.}

\item{flag}{An integer(2) vector used to filter reads based on their 
'flag' entry.}
}
\description{
Plot single cell RNAseq data as heatmap track for Seurat object.
}
\examples{
\dontrun{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
test_file <- "https://github.com/10XGenomics/subset-bam/raw/master/test/test.bam"
trs <- importScSeqScore(files=test_file, 
                        txdb=TxDb.Hsapiens.UCSC.hg19.knownGene,
                        id="653635", gene = "WASH7P")
}

}
