% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{runPCA}
\alias{runPCA}
\title{Perform PCA}
\usage{
runPCA(object, genes = NA, matrix = "auto", scree = FALSE, ...)
}
\arguments{
\item{object}{A \code{SummarizedExperiment} object.}

\item{genes}{\code{NA} or a vector of character. Perform PCA on sections if it is \code{NA}, or on given genes if it is a vector of gene names.}

\item{matrix}{Character, must be one of \code{"auto"}, \code{"count"}, \code{"normalized"}, or \code{"scaled"}. If \code{"auto"}, normalized matrix is used for sections and scaled matrix is used for genes.}

\item{scree}{Logical, plot the scree plot for PCs if it is \code{TRUE}.}

\item{...}{Other parameters passed to \code{prcomp}.}
}
\value{
A \code{SummarizedExperiment} object. The PC embeddings are saved in slot \code{meta} if PCA is performed on sections, or saved in slot \code{gene_embedding} if PCA is performed on genes.
}
\description{
Perform PCA on sections or genes in a \code{SummarizedExperiment} object for dimensionality reduction.
}
\examples{
data(zh.data)
zh <- createTomo(zh.data)

# Perform PCA on sections.
zh <- runPCA(zh)

# Plot the scree plot.
zh <- runPCA(zh, scree=TRUE)

# Perform PCA on some genes.
zh <- runPCA(zh, genes=rownames(zh)[1:100])
}
\seealso{
\code{\link[stats]{prcomp}} for performing PCA on a matrix.
}
