% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{expHeatmap}
\alias{expHeatmap}
\title{Expression heatmap}
\usage{
expHeatmap(object, genes, matrix = "scaled", size = 5)
}
\arguments{
\item{object}{A \code{SummarizedExperiment} object.}

\item{genes}{A vector of character, the name of genes to plot heatmap.}

\item{matrix}{Character, must be one of \code{"count"}, \code{"normalized"}, or \code{"scaled"}.}

\item{size}{Character, the size of gene names. Set it to 0 if you do not want to show gene names.}
}
\value{
A \code{ggplot} object.
}
\description{
Heatmap for gene expression across sections in a \code{SummarizedExperiment} object.
}
\examples{
data(zh.data)
zh <- createTomo(zh.data)

# Plot some genes.
expHeatmap(zh,
 c("ENSDARG00000002131", "ENSDARG00000003061", "ENSDARG00000076075", "ENSDARG00000076850"))

# Plot peak genes.
peak_genes <- findPeakGene(zh)
expHeatmap(zh, peak_genes$gene)

# Remove gene names if too many genes are in the heatmap.
expHeatmap(zh, peak_genes$gene, size=0)
}
