% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSilhouette.R
\name{getSilhouette}
\alias{getSilhouette}
\title{Get Silhouette Coefficient from (s)PCA, (s)PLS or block.(s)PLS clusters}
\usage{
getSilhouette(object)
}
\arguments{
\item{object}{a mixOmics object of the class \code{pca}, \code{spca}, \code{pls}, \code{spls}, \code{block.pls}, \code{block.spls}}
}
\value{
silhouette coefficient
}
\description{
\code{getSilhouette} is a generic function that compute silhouette coefficient
for an object of the type \code{pca}, \code{spca}, \code{pls}, \code{spls},
\code{block.pls}, \code{block.spls}.
}
\details{
This method extract the componant contribution depending on the object,
perform the clustering step, and compute the silhouette coefficient.
}
\examples{
demo <- suppressWarnings(get_demo_cluster())
getSilhouette(object = demo$pca)
getSilhouette(object = demo$spca)
getSilhouette(object = demo$pls)
getSilhouette(object = demo$spls)
getSilhouette(object = demo$block.pls)
getSilhouette(object = demo$block.spls)


}
