% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNcomp.R
\name{getNcomp}
\alias{getNcomp}
\title{Get optimal number of components}
\usage{
getNcomp(object, max.ncomp = NULL, X, Y = NULL, indY = NULL, ...)
}
\arguments{
\item{object}{A mixOmics object of the class `pca`, `spca`, `mixo_pls`, `mixo_spls`, `block.pls`, `block.spls`}

\item{max.ncomp}{integer, maximum number of component to include.
If no argument is given, `max.ncomp=object$ncomp`}

\item{X}{a numeric matrix/data.frame or a list of data.frame for \code{block.pls}}

\item{Y}{(only for \code{pls}, optional for \code{block.spls}) a numeric matrix, with the same nrow as \code{X}}

\item{indY}{(optional and only for \code{block.pls}, if Y is not provided), an integer which indicates the position of the matrix response in the list X}

\item{...}{Other arguments to be passed to methods (pca, pls, block.pls)}
}
\value{
\code{getNcomp} returns a list with class "ncomp.tune.silhouette" containing the following components:

\item{ncomp}{a vector containing the tested ncomp}
\item{silhouette}{a vector containing the average silhouette coefficient by ncomp}
\item{dmatrix}{the distance matrix used to compute silhouette coefficient}
}
\description{
Compute the average silhouette coefficient for a given set of components on a mixOmics result.
Foreach given ncomp, the mixOmics method is performed with the sames arguments and the given `ncomp`.
Longitudinal clustering is performed and average silhouette coefficient is computed.
}
\examples{
# random input data
demo <- suppressWarnings(get_demo_cluster())

# pca
pca.res <- mixOmics::pca(X=demo$X, ncomp = 5)
res.ncomp <- getNcomp(pca.res, max.ncomp = 4, X = demo$X)
plot(res.ncomp)

# pls
pls.res <- mixOmics::pls(X=demo$X, Y=demo$Y)
res.ncomp <- getNcomp(pls.res, max.ncomp = 4, X = demo$X, Y=demo$Y)
plot(res.ncomp)

# block.pls
block.pls.res <- suppressWarnings(mixOmics::block.pls(X=list(X=demo$X, Z=demo$Z), Y=demo$Y))
res.ncomp <- suppressWarnings(getNcomp(block.pls.res, max.ncomp = 4,
                                       X=list(X=demo$X, Z=demo$Z), Y=demo$Y))
plot(res.ncomp)

}
\seealso{
\code{\link{getCluster}}, \code{\link{silhouette}}, \code{\link[mixOmics]{pca}}, \code{\link[mixOmics]{pls}}, \code{\link[mixOmics]{block.pls}}
}
