% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyexposomics_example.R
\docType{data}
\name{tidyexposomics_example}
\alias{tidyexposomics_example}
\title{Example exposome multi-omics dataset}
\format{
An object of class \code{list} of length 6.
}
\usage{
data("tidyexposomics_example")
}
\description{
A downsampled version of the ISGlobal Exposome Data Challenge 2021
dataset (Maitre \emph{et al.}, \emph{Environment International}, 2022; DOI: 10.1016/j.envint.2022.107422).
This example dataset is included with \strong{tidyexposomics} for vignette
evaluation. This subset represents samples from children with
low socioeconomic status in the first cohort of the original dataset.
}
\details{
The data have been filtered and transformed to illustrate
the \code{tidyexposomics} workflow. Only a small subset of variables, and
the top 500 most variable features per omic layer are retained.

\strong{Contents}
\describe{
\item{meta}{A data frame of selected exposure, demographic, and
outcome variables for a subset of participants.}
\item{annotated_cb}{A data frame providing ontology-linked annotation
for the exposures in \code{meta}.}
\item{exp_filt}{A numeric matrix of gene expression values
(500 features, 48 samples) representing the top-variance transcripts.}
\item{exp_fdata}{Feature-level metadata for \code{exp_filt}, including
cleaned gene symbols.}
\item{methyl_filt}{A numeric matrix of DNA methylation M-values
(500 CpG sites, 48 samples).}
\item{methyl_fdata}{Feature-level metadata for \code{methyl_filt}.}
}

\strong{Source}

Derived from the ISGlobal Exposome Data Challenge 2021
(Maitre \emph{et al.}, \emph{Environment International}, 2022;
DOI: 10.1016/j.envint.2022.107422),licensed under CC-BY 4.0.
The original data are available on Figshare (Project 98813)
and GitHub (\code{isglobal-exposomeHub/ExposomeDataChallenge2021}).
This example dataset was processed and downsampled by the
tidyexposomics authors and is not a replacement for the full dataset.
}
\examples{
data("tidyexposomics_example")

}
\keyword{datasets}
