% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_summarize_exposures.R
\name{run_summarize_exposures}
\alias{run_summarize_exposures}
\title{Summarize Exposure Variables}
\usage{
run_summarize_exposures(exposomicset, exposure_cols = NULL, action = "add")
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object containing exposure
data in the sample metadata.}

\item{exposure_cols}{A character vector of exposure variable names
to summarize. If \code{NULL}, all numeric exposure variables are included.}

\item{action}{A string specifying the action to take. Use \code{"add"}
to attach the summary table to \code{metadata(exposomicset)} or \code{"get"}
to return the summary table directly. Default is \code{"add"}.}
}
\value{
A modified \code{MultiAssayExperiment} object (if \code{action = "add"}),
or a data frame of summary statistics (if \code{action = "get"}).
}
\description{
Computes summary statistics for numeric exposure variables and
optionally stores the results in the \code{MultiAssayExperiment} metadata.
}
\details{
This function:
\itemize{
\item Extracts sample-level exposure data using \code{pivot_sample()}.
\item Filters to user-specified exposures (\code{exposure_cols}) if provided.
\item Computes descriptive statistics for each numeric variable:
\itemize{
\item Number of values (\code{n_values})
\item Number of NAs (\code{n_na})
\item Minimum, maximum, and range
\item Sum, median, mean
\item Standard error of the mean
\item 95\% confidence interval of the mean
\item Variance, standard deviation
\item Coefficient of variation (\code{sd / mean})
}
\item Merges the result with variable metadata stored in
\code{metadata(exposomicset)$codebook}.
}
}
\examples{
# Create example data
mae <- make_example_data(
    n_samples = 20,
    return_mae = TRUE
)

# Summarize exposure data
exp_sum <- mae |>
    run_summarize_exposures(
        exposure_cols = c("age", "bmi", "exposure_pm25"),
        action = "get"
    )

}
