% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_multiomics_integration.R
\name{run_multiomics_integration}
\alias{run_multiomics_integration}
\title{Run Multi-Omics Integration}
\usage{
run_multiomics_integration(
  exposomicset,
  method = "MCIA",
  n_factors = 10,
  scale = TRUE,
  outcome = NULL,
  max.iter = 500,
  near.zero.var = TRUE,
  action = "add"
)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object with at least two assays.}

\item{method}{Character. Integration method to use. Options are
\code{"MOFA"}, \code{"MCIA"}, \code{"RGCCA"}, or \code{"DIABLO"}.}

\item{n_factors}{Integer. Number of latent factors/components to compute.
Default is 10.}

\item{scale}{Logical. Whether to scale each assay before integration.
Default is \code{TRUE}.}

\item{outcome}{Character. Required if \code{method = "DIABLO"}.
Name of outcome variable in \code{colData} used for supervised integration.}

\item{max.iter}{numeric. Option to increase the number of iterations for
\code{mixOmics::block.splsda} the default is 500.}

\item{near.zero.var}{Logical. Option to remove variables with near zero
variance for \code{mixOmics::block.splsda}, default is \code{TRUE} .}

\item{action}{Character. Whether to \code{"add"} results to the metadata or
\code{"get"} them as a list. Default is \code{"add"}.}
}
\value{
If \code{action = "add"}, returns a \code{MultiAssayExperiment} with
integration results
stored in \code{metadata(exposomicset)$multiomics_integration$integration_results}.
If \code{action = "get"}, returns a list with integration \code{method} and \code{result}.
}
\description{
Performs multi-omics integration using one of several available methods:
MOFA, MCIA, RGCCA, or DIABLO. This function takes a \code{MultiAssayExperiment}
object with two or more assays and computes shared latent factors
across omics layers.
}
\details{
\itemize{
\item \code{"MOFA"} runs Multi-Omics Factor Analysis using the \code{MOFA2} package and
returns a trained model.
\item \code{"MCIA"} runs multi-co-inertia analysis using the \code{nipalsMCIA} package.
\item \code{"RGCCA"} runs Regularized Generalized Canonical Correlation Analysis
using the \code{RGCCA} package.
\item \code{"DIABLO"} performs supervised integration using the \code{mixOmics} package
and a specified outcome.
}
}
\examples{
# create example data
mae <- make_example_data(
    n_samples = 20,
    return_mae = TRUE
)

# perform multiomics integration
mae <- run_multiomics_integration(
    mae,
    method = "DIABLO",
    outcome = "smoker",
    n_factors = 3
)

}
