% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_exposure_impact.R
\name{run_exposure_impact}
\alias{run_exposure_impact}
\title{Calculate Exposure Impact from Feature-Exposure Correlation Networks}
\usage{
run_exposure_impact(
  exposomicset,
  feature_type = c("degs", "omics", "factor_features"),
  pval_col = "adj.P.Val",
  pval_thresh = 0.1,
  action = c("add", "get")
)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object with correlation
and network metadata.}

\item{feature_type}{One of \code{"degs"}, \code{"omics"}, or \code{"factor_features"}.}

\item{pval_col}{Column in differential abundance results to filter DEGs.
Default = \code{"adj.P.Val"}.}

\item{pval_thresh}{DEG p-value threshold. Ignored unless
\code{feature_type == "degs"}.}

\item{action}{Either \code{"add"} (store in metadata) or \code{"get"} (return list).}
}
\value{
Either an updated MultiAssayExperiment (if action = "add") or a list.
}
\description{
Generalized centrality-based exposure impact analysis using DEG, omics,
or factor features.
}
\examples{
# create example data
mae <- make_example_data(
    n_samples = 10,
    return_mae = TRUE
)

# perform correlation analyses
# correlate with exposures
mae <- mae |>
    run_correlation(
        feature_type = "omics",
        variable_map = mae |>
            pivot_feature() |>
            dplyr::select(
                variable = .feature,
                exp_name = .exp_name
            ),
        exposure_cols = c("exposure_pm25", "exposure_no2", "age", "bmi")
    ) |>
    run_correlation(
        feature_type = "omics",
        variable_map = mae |>
            pivot_feature() |>
            dplyr::select(
                variable = .feature,
                exp_name = .exp_name
            ),
        feature_cors = TRUE,
        exposure_cols = c("exposure_pm25", "exposure_no2", "age", "bmi")
    )

# create the networks
mae <- mae |>
    run_create_network(
        feature_type = "omics_feature_cor",
        action = "add"
    ) |>
    run_create_network(
        feature_type = "omics",
        action = "add"
    )

# perform impact analysis
mae <- mae |>
    run_exposure_impact(
        feature_type = "omics"
    )

}
