% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_differential_abundance.R
\name{run_differential_abundance}
\alias{run_differential_abundance}
\title{Run Differential Abundance Analysis}
\usage{
run_differential_abundance(
  exposomicset,
  formula,
  abundance_col = "counts",
  method = "limma_trend",
  contrasts = NULL,
  scaling_method = "none",
  action = "add"
)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} containing assays to test.}

\item{formula}{A model formula for the differential analysis
(e.g., ~ group + batch).}

\item{abundance_col}{Character. The name of the assay matrix to use
for abundance values. Default is \code{"counts"}.}

\item{method}{Character. Differential analysis method to use.
Currently supports \code{"limma_trend"} (default).}

\item{contrasts}{A named list of contrasts for pairwise comparisons.
Default is \code{NULL} (uses default group comparisons).}

\item{scaling_method}{Character. Scaling method to apply before modeling.
Options include \code{"none"} (default), \code{"zscore"}, etc.}

\item{action}{Character. Whether to \code{"add"} results to \code{exposomicset}
metadata or \code{"get"} the results as a data frame. Default is \code{"add"}.}
}
\value{
Either the updated \code{MultiAssayExperiment} (if \code{action = "add"})
or a tibble with differential abundance results (if \code{action = "get"}).
}
\description{
Performs differential abundance testing across all assays in a
\code{MultiAssayExperiment} object using a specified statistical method.
The function updates each assay with its
corresponding \code{colData}, fits the model using the provided formula,
and combines the results into a unified table.
}
\examples{
# create example data
mae <- make_example_data(
    n_samples = 10,
    return_mae = TRUE
)

# perform differential abundance analysis
mae <- run_differential_abundance(
    exposomicset = mae,
    formula = ~ smoker + sex,
    abundance_col = "counts",
    method = "limma_trend",
    action = "add"
)

}
