% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_association.R
\name{run_association}
\alias{run_association}
\title{Run Association Analysis}
\usage{
run_association(
  exposomicset,
  outcome,
  source = c("omics", "exposures", "factors"),
  covariates = NULL,
  feature_set = NULL,
  log_trans = TRUE,
  top_n = NULL,
  family = "gaussian",
  correction_method = "fdr",
  action = "add",
  feature_col = NULL,
  mirna_assays = NULL
)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object containing data
and metadata.}

\item{outcome}{The outcome variable name (must be in \code{colData}).}

\item{source}{Source of features to test. One of \code{"omics"},
\code{"exposures"}, \code{"factors"}.}

\item{covariates}{Optional vector of covariate names to include in the model.}

\item{feature_set}{Optional character vector of exposure or GO terms to test.}

\item{log_trans}{Optional boolean value dictating whether or not to log2
transform omics features.}

\item{top_n}{Optional integer: if using omics source, select top \code{n}
most variable features.}

\item{family}{GLM family; \code{"gaussian"} or \code{"binomial"}.}

\item{correction_method}{Method for p-value adjustment (default: \code{"fdr"}).}

\item{action}{If \code{"add"} (default), saves results to metadata;
else returns results as list.}

\item{feature_col}{The column in \code{rowData}
for matching gene symbols or IDs.}

\item{mirna_assays}{Optional character vector of assays to exclude
when extracting GO terms.}
}
\value{
If \code{action = "add"}, returns updated \code{MultiAssayExperiment}.
Otherwise, returns a list of:
\itemize{
\item \code{results_df}: tidy summary of associations
\item \code{covariates}: the covariates used
\item \code{model_data}: model matrix used in the GLMs
}
}
\description{
Perform GLM-based association testing between a specified outcome and
features from exposures, omics, or latent factors. Automatically adjusts
for covariates and supports both Gaussian and binomial models.
}
\examples{

#' # create example data
mae <- make_example_data(
    n_samples = 10,
    return_mae = TRUE
)

# run association tests
mae <- mae |>
    run_association(
        source = "exposures",
        feature_set = c("exposure_pm25", "exposure_no2"),
        outcome = "smoker",
        covariates = c("age"),
        family = "binomial"
    )
}
