% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_factor_summary.R
\name{plot_factor_summary}
\alias{plot_factor_summary}
\title{Plot Summary of Factor Contributions from Multi-Omics Integration}
\usage{
plot_factor_summary(
  exposomicset,
  low = "#006666",
  mid = "white",
  high = "#8E0152",
  midpoint = 0.5
)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object containing integration
results in
\code{metadata(exposomicset)$multiomics_integration$integration_results}.}

\item{low}{Color for low values in the fill gradient.
Default is \code{"#006666"}.}

\item{mid}{Color for midpoint in the fill gradient.
Default is \code{"white"}.}

\item{high}{Color for high values in the fill gradient.
Default is \code{"#8E0152"}.}

\item{midpoint}{Midpoint value for the gradient color scale.
Default is \code{0.5}.}
}
\value{
A \code{ggplot} object showing factor contributions based on
the integration method.
}
\description{
Generates a summary plot of factor contributions from multi-omics
integration results stored in a \code{MultiAssayExperiment} object.
}
\details{
This function visualizes factor contributions based on the integration method:
\itemize{
\item \strong{MOFA}: Variance explained per factor and view.
\item \strong{MCIA}: Block score weights per omic.
\item \strong{DIABLO}: Mean absolute sample score per omic and factor
(from block-specific variates).
\item \strong{RGCCA}: Mean absolute sample score per omic and factor
(from aligned block scores).
}

The color gradient can be customized using the \code{low}, \code{mid}, \code{high},
and \code{midpoint} parameters.
}
\examples{
# create example data
mae <- make_example_data(
    n_samples = 20,
    return_mae = TRUE
)

mae <- run_multiomics_integration(
    mae,
    method = "DIABLO",
    outcome = "smoker",
    n_factors = 3
)

factor_sum_plot <- mae |>
    plot_factor_summary()

}
