% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_circos_correlation.R
\name{plot_circos_correlation}
\alias{plot_circos_correlation}
\title{Plot Circular Network of Exposure Relationships}
\usage{
plot_circos_correlation(
  exposomicset,
  feature_type = c("degs", "omics", "factors", "factor_features", "exposures", "pcs"),
  exposure_cols = NULL,
  corr_threshold = NULL,
  shared_cutoff = 10,
  annotation_colors = NULL,
  low = "#006666",
  mid = "white",
  high = "#8E0152",
  midpoint = NULL
)
}
\arguments{
\item{exposomicset}{A MultiAssayExperiment object.}

\item{feature_type}{One of "exposures", "degs", or "factors".}

\item{exposure_cols}{Character vector of exposures to include
(only for "exposures").}

\item{corr_threshold}{Minimum |correlation| (only for "exposures").}

\item{shared_cutoff}{Minimum number of shared features
(only for "degs" or "factors"). Default = 10.}

\item{annotation_colors}{Optional named vector of colors for categories.}

\item{low}{low value color for edges.}

\item{mid}{middle value color for edges.}

\item{high}{high value color for edges.}

\item{midpoint}{Midpoint for edge color gradient. Defaults to 0
(for correlations) or mean shared features.}
}
\value{
A ggplot object (ggraph circular plot).
}
\description{
Generates a circular network plot to visualize relationships between
exposures, either based on correlation ("exposures") or
shared features ("degs", "factors").
}
\examples{

# create example data
mae <- make_example_data(
    n_samples = 10,
    return_mae = TRUE
)

# run correlation analysis
mae <- mae |>
    run_correlation(
        feature_type = "exposures",
        exposure_cols = c("exposure_pm25", "exposure_no2", "age", "bmi")
    )

# create the circos plot
circos_plot <- mae |>
    plot_circos_correlation(
        feature_type = "exposures"
    )

}
