% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_feature.R
\name{pivot_feature}
\alias{pivot_feature}
\title{Extract Feature Metadata from a MultiAssayExperiment}
\usage{
pivot_feature(exposomicset)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object.}
}
\value{
A tibble with feature metadata from all assays,
with an added \code{.exp_name} column.
}
\description{
Extracts feature-level metadata across all assays in a
\code{MultiAssayExperiment} and returns a combined tibble.
}
\details{
This function:
\itemize{
\item Iterates over all assays in the \code{MultiAssayExperiment}.
\item Updates each assay's sample metadata (\code{colData}) using
\code{.update_assay_colData()}.
\item Extracts feature-level metadata using \code{pivot_transcript()} from \code{tidybulk}.
\item Combines results across assays into a single tibble,
adding a \code{.exp_name} column.
}
}
\examples{

#' # create example data
mae <- make_example_data(
    n_samples = 10,
    return_mae = TRUE
)

# pivot experiment
feature_data <- mae |>
    pivot_feature()
}
