% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_exp.R
\name{pivot_exp}
\alias{pivot_exp}
\title{Pivot a selected omics dataset from a MultiAssayExperiment into tidybulk format}
\usage{
pivot_exp(exposomicset, exp_name, features = NULL)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object containing
one or more omics assays.}

\item{exp_name}{A character string. The name of the omics dataset
to extract (e.g., "Proteomics").}

\item{features}{Optional character vector of row (feature) names to retain.
If \code{NULL}, all features are included.}
}
\value{
A tibble in tidy format with one row per feature/sample pair,
including all metadata and a new column \code{exp_name}
indicating the assay source. Assay values are provided in separate columns
named after the assay slot(s).
}
\description{
Extracts a specified omics dataset from a \code{MultiAssayExperiment},
optionally filters by feature (row) names,
and returns a tidy tibble. The output includes assay values along with
sample metadata and feature metadata.
}
\examples{
# create example data
mae <- make_example_data(
    n_samples = 10,
    return_mae = TRUE
)

# pivot experiment
exp_data <- pivot_exp(
    exposomicset = mae,
    exp_name = "mRNA",
    features = c("feat_42")
)

}
