% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_example_data.R
\name{make_example_data}
\alias{make_example_data}
\title{Generate Example Data for Testing}
\usage{
make_example_data(
  n_samples = 12,
  n_proteins = 80,
  use_batch = FALSE,
  return_mae = FALSE
)
}
\arguments{
\item{n_samples}{Integer. Number of samples to simulate (default: 12).}

\item{n_proteins}{Integer. Number of proteins to simulate (default: 80).}

\item{use_batch}{Logical. If \code{TRUE},
include a "batch" variable in the exposure data (default: FALSE).}

\item{return_mae}{Logical. If \code{TRUE},
return a \code{MultiAssayExperiment} created using
\code{create_exposomicset()} (default: FALSE).}
}
\value{
Either:
\itemize{
\item A named list containing \code{codebook},
\code{exposure}, \code{omics}, and \code{row_data},
if \code{return_mae = FALSE}.
\item A \code{MultiAssayExperiment}, if \code{return_mae = TRUE}.
}
}
\description{
This helper function generates a reproducible dummy dataset
containing exposures, mRNA data, and proteomics data. It can
optionally return the data as a \code{MultiAssayExperiment} using
\code{\link{create_exposomicset}}.
}
\examples{
# Return as a list
dummy <- make_example_data()

# Return as a MultiAssayExperiment
mae <- make_example_data(return_mae = TRUE)

}
